# coding=utf-8
from sandbox import sdk2
from sandbox.projects.cajuper.common import index_state_types
from sandbox.projects.cajuper import resources


def find_resource(task_id, resource_type):
    return resource_type.find(task_id=task_id).first()


def run_state_creator(self_task, db_timestamp, project):
    sub_task = sdk2.Task['BUILD_INDEX_STATE_FILE'](
        self_task,
        notifications=self_task.Parameters.notifications,
        create_sub_task=False,
        db_timestamp=db_timestamp,
        description='{} DB timestamp {} ({})'.format(
            project,
            db_timestamp,
            index_state_types.timestamp_to_yt_state(db_timestamp)
        ),
        state_for_project=project,
        tags=[project],
    ).enqueue()
    return sub_task


def copy_resource(self_task, resource, new_resource_type=None, new_resource_filename=None):
    resource_data = sdk2.ResourceData(resource)
    new_resource_type = new_resource_type or resource.type

    with open(str(resource_data.path)) as src_file:
        resource_copy = sdk2.ResourceData(
            new_resource_type(
                self_task,
                resource.description,
                new_resource_filename or str(resource.path),
            )
        )
        resource_copy.path.write_bytes(src_file.read())

    return resource_copy


def copy_index_state_resources(self_task, task_with_resource_id, project):
    copies = []

    for generator in index_state_types.RESOURCES_BY_PROJECTS[project]:
        copies.append(copy_resource(
            self_task,
            find_resource(
                task_id=task_with_resource_id,
                resource_type=generator.get_resource_type()
            )
        ))
    return copies


def get_chunk_configs_bundle_resource_type(tier):
    if tier == 'WebTier0':
        return resources.CajuperTier0ChunksConfigsBundle
    elif tier == 'WebTier1':
        return resources.CajuperTier1ChunksConfigsBundle
    elif tier == 'VideoPlatinum':
        return resources.CajuperVideoPlatinumChunksConfigsBundle
    elif tier == 'ImgTier0':
        return resources.CajuperImagesTier0ChunksConfigsBundle

    return None
