from sandbox import sdk2


DB_RELEASERS = [
    'andreikkaa',
    'glebx777',
    'mcden',
    'okats',
    'shotinleg',
    'sskvor',
    'ssmike',
    'alexbykov',
    'khlebnikov',
    'ulyanin',
    'flyrise',
    'bazarinm',
]

IMGS_DB_RELEASERS = DB_RELEASERS + [
    'anskor',
    'igorluk',
    'krivokon',
    'pupatenko',
    'sakhnov',
    'ulgen4a',
    'kozlovkr',
    'robot-images-sandbox',
    'robot-images',
    'robot-imgbase',
]


class CallistoAllPrograms(sdk2.Resource):
    """
    Callisto all programs
    """
    releasable = True
    auto_backup = True
    executable = True
    arcadia_build_path = 'infra/callisto'


class ShardtoolV2(sdk2.Resource):
    """
        Tool for export shards from YT
    """
    releasable = True
    auto_backup = True
    executable = True
    arcadia_build_path = 'infra/callisto/shardtool'


class CallistoAgent(sdk2.Resource):
    """
        Callisto agent
    """
    releasable = True
    auto_backup = True
    executable = True
    arcadia_build_path = 'infra/callisto/agent'


class CallistoController(sdk2.Resource):
    """
        Callisto controller
    """
    releasable = True
    auto_backup = True
    executable = True
    arcadia_build_path = 'infra/callisto/runner'


class CallistoInstanceCtlHelper(sdk2.Resource):
    """
    helper to configure service in rtc
    """
    releasable = True
    auto_backup = True
    executable = True
    arcadia_build_path = 'infra/callisto/tools/instancectl_helper'


class CallistoYasmSubAgent(sdk2.Resource):
    """
    Callisto yasm sub-agent
    """
    releasable = True
    auto_backup = True
    executable = True
    arcadia_build_path = 'infra/callisto/tools/yasmca_agent'


class CallistoYtNodeCHecker(sdk2.Resource):
    """
    Callisto yt node checker
    """
    releasable = True
    auto_backup = True
    executable = True
    arcadia_build_path = 'infra/callisto/tools/yt_node_checker'


class CajuperTrackerClient(sdk2.Resource):
    """
    cajuper tracker client binary
    """
    releasable = True
    auto_backup = True
    executable = True
    arcadia_build_path = 'infra/callisto/tools/tracker_client'


class SimplePipeBalancerConfig(sdk2.Resource):
    """
        balancer config for simple single port backends (like basesearch)
    """
    releasable = True
    releasers = DB_RELEASERS


class CajuperImagesTier0ChunksConfigsBundle(sdk2.Resource):
    """
        bundle with ImgTier0 configs about shards chunks and their location
    """
    releasable = True
    releasers = IMGS_DB_RELEASERS


class CajuperVideoPlatinumChunksConfigsBundle(sdk2.Resource):
    """
        bundle with VideoPlatnum configs about shards chunks and their location
    """
    releasable = True
    releasers = DB_RELEASERS


class CajuperTier0ChunksConfigsBundle(sdk2.Resource):
    """
        bundle with WebTier0 configs about shards chunks and their location
    """
    releasable = True
    releasers = DB_RELEASERS


class CajuperTier1ChunksConfigsBundle(sdk2.Resource):
    """
        bundle with WebTier1 configs about shards chunks and their location
    """
    releasable = True
    releasers = DB_RELEASERS


class CajuperChunksConfigsBundle(sdk2.Resource):
    """
        bundle with configs about shards chunks and their location
    """
    releasable = True
    releasers = DB_RELEASERS


class HeaterBasesearchPlan(sdk2.Resource):
    """
        basesearch plan is used for heat up web basesearch instances
    """
    releasable = True
    releasers = DB_RELEASERS

    # custom attributes
    tier = sdk2.parameters.String("Tier")


class HeaterMmetaPlan(sdk2.Resource):
    """
        mmeta plan is used for heat up web basesearch instances
    """
    auto_backup = True
    releasable = True
    releasers = DB_RELEASERS
    sync_upload_to_mds = False


class HeaterPlanBundle(sdk2.Resource):
    """
        bundle with heater plans
    """
    releasable = True
    releasers = DB_RELEASERS


class ImagesProductionIndexStateResource(sdk2.Resource):
    """
    Resource with images search index state for production services
    """
    releasable = True
    releasers = IMGS_DB_RELEASERS


class ImagesProductionIndexStateJsonResource(sdk2.Resource):
    """
    Resource with images search index state for production services
    """
    releasable = True
    releasers = IMGS_DB_RELEASERS


class ImagesRimProductionIndexStateResource(sdk2.Resource):
    """
    Resource with images RIM search index state for production services
    """
    releasable = True
    releasers = IMGS_DB_RELEASERS
    shard_instance = sdk2.Attributes.String("Shard name")


class ImagesRimProductionIndexStateJsonResource(sdk2.Resource):
    """
    Resource with images RIM search index state for production services
    """
    releasable = True
    releasers = IMGS_DB_RELEASERS
    shard_instance = sdk2.Attributes.String("Shard name")


class ImagesCommercialProductionIndexStateResource(sdk2.Resource):
    """
    Resource with images commercial db index state for production services
    """
    releasable = True
    releasers = IMGS_DB_RELEASERS + ["robot-images-money"]
    shard_instance = sdk2.Attributes.String("Shard name")


class VideoProductionIndexStateResource(sdk2.Resource):
    """
    Resource with video search index state for production services
    """
    releasable = True
    releasers = DB_RELEASERS + [
        'vkap',
    ]


class VideoProductionIndexStateJsonResource(sdk2.Resource):
    """
    Resource with video search index state for production services
    """
    releasable = True
    releasers = DB_RELEASERS + [
        'vkap',
    ]


class WebProductionIndexStateResource(sdk2.Resource):
    """
    Resource with web search index state for production services
    """
    releasable = True
    releasers = DB_RELEASERS


class WebProductionYtIndexStateResource(sdk2.Resource):
    """
    Resource with web search index state for production services deployed from YT
    """
    releasable = True
    releasers = DB_RELEASERS


class WebProductionYtBeta1IndexStateResource(sdk2.Resource):
    """
    Resource with web search index state for production services deployed from YT
    """
    releasable = True
    releasers = DB_RELEASERS


class WebProductionYtBeta2IndexStateResource(sdk2.Resource):
    """
    Resource with web search index state for production services deployed from YT
    """
    releasable = True
    releasers = DB_RELEASERS


class WebProductionYtBeta3IndexStateResource(sdk2.Resource):
    """
    Resource with web search index state for production services deployed from YT
    """
    releasable = True
    releasers = DB_RELEASERS


class WebProductionYtBeta4IndexStateResource(sdk2.Resource):
    """
    Resource with web search index state for production services deployed from YT
    """
    releasable = True
    releasers = DB_RELEASERS


class WebProductionYtBeta5IndexStateResource(sdk2.Resource):
    """
    Resource with web search index state for production services deployed from YT
    """
    releasable = True
    releasers = DB_RELEASERS


class WebProductionIndexStateJsonResource(sdk2.Resource):
    """
    Resource with web search index state for production services
    """
    releasable = True
    releasers = DB_RELEASERS


class WebProductionYtIndexStateJsonResource(sdk2.Resource):
    """
    Resource with web search index state for production services deployed from YT
    """
    releasable = True
    releasers = DB_RELEASERS


class WebProductionYtBeta1IndexStateJsonResource(sdk2.Resource):
    """
    Resource with web search index state for production services deployed from YT
    """
    releasable = True
    releasers = DB_RELEASERS


class WebProductionYtBeta2IndexStateJsonResource(sdk2.Resource):
    """
    Resource with web search index state for production services deployed from YT
    """
    releasable = True
    releasers = DB_RELEASERS


class WebProductionYtBeta3IndexStateJsonResource(sdk2.Resource):
    """
    Resource with web search index state for production services deployed from YT
    """
    releasable = True
    releasers = DB_RELEASERS


class WebProductionYtBeta4IndexStateJsonResource(sdk2.Resource):
    """
    Resource with web search index state for production services deployed from YT
    """
    releasable = True
    releasers = DB_RELEASERS


class WebProductionYtBeta5IndexStateJsonResource(sdk2.Resource):
    """
    Resource with web search index state for production services deployed from YT
    """
    releasable = True
    releasers = DB_RELEASERS


class WebRuntimePlatinumDeployLayer(sdk2.Resource):
    """
    Layer for Platinum @ Deploy
    """
    releasable = True
    releasers = DB_RELEASERS
    arcadia_build_path = 'infra/callisto/packages/web/platinum/package.json'


class WebRuntimeTier0DeployLayer(sdk2.Resource):
    """
    Layer for WebTier1 @ Deploy
    """
    releasable = True
    releasers = DB_RELEASERS
    arcadia_build_path = 'infra/callisto/packages/web/tier0/package.json'


class WebRuntimeTier1DeployLayer(sdk2.Resource):
    """
    Layer for WebTier1 @ Deploy
    """
    releasable = True
    releasers = DB_RELEASERS
    arcadia_build_path = 'infra/callisto/packages/web/tier1/package.json'


class WebRuntimeKeyInvTier0DeployLayer(sdk2.Resource):
    """
    Layer for WebTier0 KeyInv @ Deploy
    """
    releasable = True
    releasers = DB_RELEASERS
    arcadia_build_path = 'infra/callisto/packages/web/keyinv/package.json'


class WebRuntimeIntDeployLayer(sdk2.Resource):
    """
    Layer for Web Int @ Deploy
    """
    releasable = True
    releasers = DB_RELEASERS
    arcadia_build_path = 'infra/callisto/packages/web/int/package.json'


class WebRuntimeIntL2DeployLayer(sdk2.Resource):
    """
    Layer for Web Int @ Deploy
    """
    releasable = True
    releasers = DB_RELEASERS
    arcadia_build_path = 'infra/callisto/packages/web/intl2/package.json'


class WebRuntimeInvIndexDeployLayer(sdk2.Resource):
    """
    Layer for Web InvIndex @ Deploy
    """
    releasable = True
    releasers = DB_RELEASERS
    arcadia_build_path = 'infra/callisto/packages/web/invindex/package.json'


class WebRuntimeEmbeddingDeployLayer(sdk2.Resource):
    """
    Layer for Web Embedding @ Deploy
    """
    releasable = True
    releasers = DB_RELEASERS
    arcadia_build_path = 'infra/callisto/packages/web/embedding/package.json'


class ImagesRuntimeDeployLayer(sdk2.Resource):
    """
    Common layer for images @ Deploy
    """
    releasable = True
    releasers = IMGS_DB_RELEASERS


class ImagesRimDaemonDeployLayer(sdk2.Resource):
    """
    Common layer for images rim_daemon @ Deploy
    """
    releasable = True
    releasers = IMGS_DB_RELEASERS
    arcadia_build_path = 'infra/callisto/packages/images/rim/package.json'


class VideoRuntimeDeployLayer(sdk2.Resource):
    """
    Common layer for video @ Deploy
    """
    releasable = True
    releasers = DB_RELEASERS + [
        'vkap',
        'kuskarov',
        'slobodetskiy'
    ]
