import datetime

from sandbox import sdk2
from sandbox.sandboxsdk.process import run_process

from sandbox.projects.common.environments import MongodbEnvironment


# uploaded to sandbox mongodump bin (v3.4)
MONGODUMP_BIN_RESOURCE_ID = 564296792


class CanvasMongoDumpResource(sdk2.Resource):
    ttl = 60  # days


class CanvasMongoDump(sdk2.Task):
    """
    Makes mongodump (warn: without oplog, because we has no required
    permissions) from Canvas MongoDB cluster (mdbaas) and publish it as
    sandbox resource

    TODO: either encrypt dump or somehow restrict access to resources
    """

    class Parameters(sdk2.Task.Parameters):
        mongo_connection_uri_vault_user = sdk2.parameters.String(
            "Mongo connection URI vault user",
            default="CANVAS",
        )
        mongo_connection_uri_vault_name = sdk2.parameters.String(
            "Mongo connection URI vault name",
            default="canvas-production-mongo",
        )

    class Requirements(sdk2.Task.Requirements):
        environments = [MongodbEnvironment()]

    def get_mongo_connection_uri(self):
        return sdk2.Vault.data(
            self.Parameters.mongo_connection_uri_vault_user,
            self.Parameters.mongo_connection_uri_vault_name,
        )

    def on_execute(self):
        mongodump = str(sdk2.ResourceData(
            sdk2.Resource.find(id=MONGODUMP_BIN_RESOURCE_ID).first(),
        ).path)

        resource = sdk2.ResourceData(CanvasMongoDumpResource(
            self,
            "mongodump {}: {} [{}]".format(
                self.Parameters.mongo_connection_uri_vault_user,
                self.Parameters.mongo_connection_uri_vault_name,
                datetime.datetime.now().isoformat(),
            ),
            "canvas_mongodump.tar.gz",
        ))

        run_process([
            mongodump,
            "--gzip",
            "--archive={}".format(resource.path),
            "--uri={}".format(self.get_mongo_connection_uri()),
            "-vvv",
        ])

        resource.ready()
