# -*- coding: utf-8 -*-

import logging
import urlparse

from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment


logger = logging.getLogger(__name__)


class CanvasCleanupVideoFiles(sdk2.Task):
    """
    Ex background worker's task
    """

    class Requirements(sdk2.Requirements):
        cores = 1
        # TODO: find out how to use versions and not to fail :(
        environments = (
            PipEnvironment("requests"),
        )

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        video_additions_api_url = sdk2.parameters.Url(
            "URL to video-additions backend",
            default="http://backend.production.canvas.mediaselling.stable.qloud-d.yandex.net/",
            required=True,
        )
        file_age_seconds = sdk2.parameters.Integer(
            "Cleanup files older than X seconds",
            default=300,
            required=True,
        )

        video_additions_api_internal_token_vault_user = sdk2.parameters.String(
            "Video additions internal token vault user",
            default="CANVAS",
        )
        video_additions_api_internal_token_vault_name = sdk2.parameters.String(
            "Video additions internal token vault name",
            default="canvas-production-video-additions-api-internal-token",
        )

    def get_video_additions_api_internal_token(self):
        return sdk2.Vault.data(
            self.Parameters.video_additions_api_internal_token_vault_user,
            self.Parameters.video_additions_api_internal_token_vault_name,
        )

    def on_execute(self):
        import requests

        logger.info('Starting video files cleanup')

        video_additions_api_url = str(self.Parameters.video_additions_api_url)

        result = requests.post(
            urlparse.urljoin(video_additions_api_url, '/video/files/tasks/cleanup'),
            json={"age_seconds": int(self.Parameters.file_age_seconds)},
            params={"token": self.get_video_additions_api_internal_token()},
        )

        if result.status_code != 200:
            raise Exception('POST {}/video/files/tasks/cleanup responded {} ({})'.format(
                video_additions_api_url,
                result.status_code,
                result.text,
            ))

        logger.info('Video files cleanup passed OK, result: %s', result.json())
