# coding: utf-8

import logging
from sandbox import sdk2
import sandbox.common.types.misc as ctm
import tempfile
import json
from .. import video_constructor_utils as vc_utils


class CanvasVideoRebuildPackshot(sdk2.Task):
    """ rebuild packshot for video using ffmpeg """

    entity = "packshot"
    file_extenstion = ".png"
    file_name = "ad" + file_extenstion

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        ram = 8192
        dns = ctm.DnsType.DNS64

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Task.Parameters):
        container = sdk2.parameters.Container(
            "LXC Container",
            default_value=vc_utils.DEFAULT_CONTAINER_ID,
            required=True
        )
        max_restarts = 1
        id_to_video_data = sdk2.parameters.JSON("Video id -> Video data (mp4url, template id and so on)", required=True)
        webhook_url = sdk2.parameters.String("Webhook URL")
        with sdk2.parameters.Output:
            results = sdk2.parameters.JSON("Results", required=False)

    def convert(self, mp4Url, out_temp_path, template_id=None):
        vc_utils.mp42packshot(self, self.ffmpeg_bin, mp4Url, out_temp_path, template_id=template_id)

    def convert_all(self, id_to_video_data):
        """для каждого видео создается packshot и отправляется в stillage"""

        results = []
        for id, video_data in id_to_video_data.items():
            out_temp_path = tempfile.NamedTemporaryFile().name + self.file_extenstion
            self.convert(video_data["mp4Url"], out_temp_path, template_id=video_data.get("templateId"))

            # отправляем в stillage
            with open(out_temp_path) as data_fh:
                stillage_res = vc_utils.upload_to_stillage(self._session, data_fh.read(), self.file_name)

            stillage_res_dict = stillage_res.json()
            logging.info(str(stillage_res_dict))

            if stillage_res_dict and 'id' in stillage_res_dict and 'url' in stillage_res_dict:
                results.append({
                    'id': id,
                    self.entity + '_stillage_id': stillage_res_dict['id'],
                    self.entity + '_url': stillage_res_dict['url']
                })
            else:
                logging.error("Can't upload to stillage (id=%s, video_data=%s)" % (id, video_data))

        return results

    def on_execute(self):
        self._session = vc_utils.init_session()
        self.ffmpeg_bin = '/usr/local/bin/ffmpeg'

        id_to_video_data_dict = json.loads(self.Parameters.id_to_video_data)
        results = self.convert_all(id_to_video_data_dict)
        self.Parameters.results = results

        # вызываем webhook_url
        if self.Parameters.webhook_url:
            try:
                logging.debug('web hook to %s with %s', self.Parameters.webhook_url, results)
                self._session.post(self.Parameters.webhook_url, json=results, timeout=1, verify=False)
            except Exception:
                logging.exception('web hook failed send post request to %s', self.Parameters.webhook_url)
