import time

from driver import Driver, SchemaColumn


class AudioFilesDriver(Driver):
    schema = [
        SchemaColumn(schema={"name": "date", "type": "uint64"}, transformer=lambda b, c: int(time.mktime(b["date"].timetuple()))),
        SchemaColumn(schema={"name": "id", "type": "string"}, transformer=lambda b, c: str(b["_id"])),
        SchemaColumn(schema={"name": "client_id", "type": "uint32"}, transformer=lambda b, c: int(b["client_id"])),
        SchemaColumn(schema={"name": "name", "type": "string"}),
        SchemaColumn(schema={"name": "archive", "type": "boolean"}),
        SchemaColumn(schema={"name": "status", "type": "string"}),
        SchemaColumn(schema={"name": "url", "type": "string"}),
        SchemaColumn(schema={"name": "stillage_id", "type": "string"}),
    ]
    yt_dump_dir = "//home/canvas/audio_files"

    def fetch(self):
        return self.mongo.audio_files.find()

    def transform(self, audio_files):
        rows = []
        for audio_file in audio_files:
            row = {}
            for column in self.schema:
                row[column.name()] = column.transform(audio_file, audio_file)
            rows.append(row)
        return rows
