import time

from .driver import Driver, SchemaColumn


def transformer_data(_, c):
    """
    Sanitizes ObjectId in mediaSet's files
    :return: jsonable data
    """
    if "data" not in c:
        return None
    data = c["data"]
    if "image" in data["mediaSets"]:
        for it1 in data["mediaSets"]["image"]["items"]:
            for it2 in it1["items"]:
                if "fileId" in it2:
                    it2["fileId"] = str(it2["fileId"])
                if "croppedFileId" in it2:
                    it2["croppedFileId"] = str(it2["croppedFileId"])
    if "logo" in data["mediaSets"]:
        for it1 in data["mediaSets"]["logo"]["items"]:
            for it2 in it1["items"]:
                if "fileId" in it2:
                    it2["fileId"] = str(it2["fileId"])
                if "croppedFileId" in it2:
                    it2["croppedFileId"] = str(it2["croppedFileId"])
    return data


class CreativesDriver(Driver):
    schema = [
        SchemaColumn(schema={"name": "date", "type": "uint64"}, transformer=lambda b, c: int(time.mktime(b["date"].timetuple()))),
        SchemaColumn(schema={"name": "id", "type": "uint64"}, transformer=lambda b, c: int(c["_id"])),
        SchemaColumn(schema={"name": "client_id", "type": "uint32"}, transformer=lambda b, c: int(b["clientId"])),
        SchemaColumn(schema={"name": "name", "type": "string"}),
        SchemaColumn(schema={"name": "data", "type": "any"}, transformer=transformer_data),
        SchemaColumn(schema={"name": "batch_id", "type": "string"}, transformer=lambda b, c: str(b["_id"])),
        SchemaColumn(schema={"name": "idea_id", "type": "string"}, transformer=lambda b, c: str(b.get("ideaId")) if "ideaId" in b else None),
        SchemaColumn(schema={"name": "archive", "type": "boolean"}, transformer=lambda b, c: c.get("available")),
        SchemaColumn(schema={"name": "creative_url", "type": "string"}, transformer=lambda b, c: c.get("creativeURL")),
        SchemaColumn(schema={"name": "screenshot_url", "type": "string"}, transformer=lambda b, c: c.get("screenshotURL")),
    ]
    yt_dump_dir = '//home/canvas/creatives'

    def fetch(self):
        return self.mongo.creative_batch.find({"date": {"$exists": True}, "clientId": {"$exists": True}})

    def transform(self, batches):
        rows = []
        for batch in batches:
            for creative in batch["items"]:
                row = {}
                for column in self.schema:
                    row[column.name()] = column.transform(batch, creative)
                rows.append(row)
        return rows
