# coding: utf-8

import time
from bson.binary import Binary
import base64

from driver import Driver, SchemaColumn


def convert_binary_to_string(son):
    """
    Конвертируем формат Binary в строку
    """
    if son is None or not isinstance(son, dict):
        return son

    for key, value in son.items():
        if isinstance(value, Binary):
            son[key] = base64.b64encode(value)
        elif isinstance(value, dict):
            son[key] = convert_binary_to_string(value)

    return son


class FilesDriver(Driver):
    schema = [
        SchemaColumn(schema={"name": "id", "type": "string"}, transformer=lambda b, c: str(b["_id"])),
        SchemaColumn(schema={"name": "originalFileId", "type": "string"},
                     transformer=lambda b, c: str(b["originalFileId"]) if b.get("originalFileId") is not None else None),
        SchemaColumn(schema={"name": "stockFileId", "type": "string"}),
        SchemaColumn(schema={"name": "ideaId", "type": "string"}),
        SchemaColumn(schema={"name": "name", "type": "string"}),
        SchemaColumn(schema={"name": "stillageFileId", "type": "string"}),
        SchemaColumn(schema={"name": "stillageFileInfo", "type": "any"},
                     transformer=lambda b, c: convert_binary_to_string(b.get("stillageFileInfo"))),
        SchemaColumn(schema={"name": "url", "type": "string"}),
        SchemaColumn(schema={"name": "previewUrl", "type": "string"}),
        SchemaColumn(schema={"name": "thumbnailUrl", "type": "string"}),
        SchemaColumn(schema={"name": "largePreviewUrl", "type": "string"}),
        SchemaColumn(schema={"name": "cropSourceUrl", "type": "string"}),
        SchemaColumn(schema={"name": "cropParameters", "type": "any"}),
        SchemaColumn(schema={"name": "turboParameters", "type": "any"}),
        SchemaColumn(schema={"name": "date", "type": "uint64"},
                     transformer=lambda b, c: int(time.mktime(b["date"].timetuple()))),
        SchemaColumn(schema={"name": "clientId", "type": "uint32"},
                     transformer=lambda b, c: int(b["clientId"]) if b.get("clientId") is not None else None),
        SchemaColumn(schema={"name": "userId", "type": "uint32"},
                     transformer=lambda b, c: int(b["userId"]) if b.get("userId") is not None else None),
        SchemaColumn(schema={"name": "archive", "type": "boolean"}),
    ]
    yt_dump_dir = "//home/canvas/files"

    cleanup_ignore_x_first_dumps = 5

    def fetch(self):
        return self.mongo.files.find()

    def transform(self, files):
        rows = []
        for file in files:
            row = {}
            for column in self.schema:
                row[column.name()] = column.transform(file, file)
            rows.append(row)
        return rows
