import time

from .driver import Driver, SchemaColumn


class Html5CreativesDriver(Driver):
    schema = [
        SchemaColumn(schema={"name": "date", "type": "uint64"}, transformer=lambda b, c: int(time.mktime(b["date"].timetuple()))),
        SchemaColumn(schema={"name": "id", "type": "uint64"}, transformer=lambda b, c: int(c["id"])),
        SchemaColumn(schema={"name": "client_id", "type": "uint32"}, transformer=lambda b, c: int(b["client_id"])),
        SchemaColumn(schema={"name": "name", "type": "string"}),
        SchemaColumn(schema={"name": "batch_id", "type": "string"}, transformer=lambda b, c: str(b["_id"])),
        SchemaColumn(schema={"name": "product_type", "type": "string"}, transformer=lambda b, c: str(b.get("product_type")) if "product_type" in b else None),
        SchemaColumn(schema={"name": "archive", "type": "boolean"}, transformer=lambda b, c: c.get("available")),
        SchemaColumn(schema={"name": "archive_url", "type": "string"}, transformer=lambda b, c: c.get("archive_url")),
    ]
    yt_dump_dir = '//home/canvas/html5_creatives'

    def fetch(self):
        return self.mongo.html5_batches.find()

    def transform(self, batches):
        rows = []
        for batch in batches:
            for creative in batch["creatives"]:
                row = {}
                for column in self.schema:
                    row[column.name()] = column.transform(batch, creative)
                rows.append(row)
        return rows
