
from driver import Driver, SchemaColumn
import time


def wipe_md5hash(idea, *args):
    data = idea["scraperData"]
    for file in data["images"]:
        file["md5Hash"] = ""
    for file in data["logos"]:
        file["md5Hash"] = ""
    return data


class IdeasDriver(Driver):
    schema = [
        SchemaColumn(schema={"name": "date", "type": "uint64"}, transformer=lambda b, c: int(time.mktime(b["date"].timetuple()))),
        SchemaColumn(schema={"name": "id", "type": "string"}, transformer=lambda b, c: str(c["_id"])),
        SchemaColumn(schema={"name": "client_id", "type": "uint32"}, transformer=lambda b, c: int(b["clientId"])),
        SchemaColumn(schema={"name": "data", "type": "any"}, transformer=wipe_md5hash),
        SchemaColumn(schema={"name": "archive", "type": "boolean"}),
        SchemaColumn(schema={"name": "url", "type": "string"}, transformer=lambda b, c: b["requestedUrl"]),
    ]
    yt_dump_dir = "//home/canvas/ideas"

    def fetch(self):
        return self.mongo.idea.find()

    def transform(self, ideas):
        rows = []
        for idea in ideas:
            row = {}
            for column in self.schema:
                row[column.name()] = column.transform(idea, idea)
            rows.append(row)
        return rows
