# coding: utf-8

import collections

from driver import Driver, SchemaColumn


class LandingConversionGoalsDriver(Driver):
    """
    https://st.yandex-team.ru/BSDEV-68315#1519825264000
    """

    schema = [
        SchemaColumn(schema={"name": "counter_id", "type": "uint64"}),
        SchemaColumn(schema={"name": "goal_id", "type": "uint64"}),
    ]

    yt_dump_dir = "//home/canvas"

    valid_goals = [
        "Отправка заявки из формы",
        "Нажатие кнопки обратной связи — Телефон",
        "Успешное совершение заказа",
        "Sent request form",
        "Clicked on call button",
        "Placed a new order",
        "Turbo Pages - Form page - Send data button click",
        "Turbo Pages - Title page - Contact button call"
    ]

    def __init__(self, *args, **kwargs):
        super(LandingConversionGoalsDriver, self).__init__(*args, **kwargs)

        # cursor offset
        self._current_offset = 0

    def generate_table_name(self):
        return "BSDEV-68315_landing_conversion_goals"

    def fetch(self):
        import psycopg2.extras
        # TODO: calculate rows lazy

        cursor = self.lpc_psycopg2_connection.cursor(cursor_factory=psycopg2.extras.NamedTupleCursor)

        cursor.execute("""
            SELECT
            pd."data" #> '{props,userMetrika}' AS "userMetrika",
            coalesce(pd."data" #> '{props,technicalMetrika}', pd."data" #> '{props,technicalMetrikaId}') AS "technicalMetrika"
            FROM pages_publishes pp
            JOIN page_versions pv ON pp."nodeId" = pv."nodeId" AND pp.version = pv.max_published_version
            LEFT JOIN nodes n ON n.id = pp."nodeId"
            LEFT JOIN pages_data pd ON pd."nodeId" = pp."nodeId" AND pd.version = pp.version
            WHERE n."deletedAt" IS NULL
            AND coalesce(
                nullif(pd."data"->'props'->>'userMetrika', ''),
                pd."data"->'props'->>'technicalMetrika',
                pd."data"->'props'->>'technicalMetrikaId',
                ''
            ) != ''
        """)

        counter_to_goal = collections.defaultdict(set)

        for row in cursor:
            metrika_info = row.userMetrika or row.technicalMetrika
            counter_to_goal[int(metrika_info["id"])].update(
                int(goal["id"])
                for goal in metrika_info["goals"]
                if (row.userMetrika and goal.get("weight", 0) > 0)
                or (row.technicalMetrika and goal["name"] in self.valid_goals)
            )

        rows = []

        for counter_id, goal_ids in counter_to_goal.iteritems():
            for goal_id in goal_ids:
                rows.append({"counter_id": counter_id, "goal_id": goal_id})

        return rows

    def get_next_batch(self, iterable):
        next_offset = self._current_offset + self.batch_size
        res = iterable[self._current_offset:next_offset]
        self._current_offset = next_offset
        return res

    @staticmethod
    def get_count(iterable):
        return len(iterable)

    def transform(self, rows):
        transformed_rows = []

        for row in rows:
            transformed_row = {}
            for column in self.schema:
                transformed_row[column.name()] = column.transform(row, None)
            transformed_rows.append(transformed_row)

        return transformed_rows

    def cleanup(self):
        # there is no historical tables
        pass
