import time

from driver import Driver, SchemaColumn


class LandingsDriver(Driver):
    schema = [
        SchemaColumn(schema={"name": "id", "type": "uint64"}, transformer=lambda b, c: int(b["id"])),
        SchemaColumn(schema={"name": "path", "type": "any"}),
        SchemaColumn(schema={"name": "author", "type": "string"}),
        SchemaColumn(schema={"name": "status", "type": "string"}),
        SchemaColumn(
            schema={"name": "createdAt", "type": "uint64"},
            transformer=lambda b, c: int(time.mktime(b["createdAt"].timetuple()))
        ),
        SchemaColumn(
            schema={"name": "deletedAt", "type": "uint64"},
            transformer=lambda b, c: int(time.mktime(b["deletedAt"].timetuple())) if b["deletedAt"] else None,
        ),
        SchemaColumn(schema={"name": "screenshots", "type": "any"}),
    ]
    yt_dump_dir = "//home/canvas/lpc-landings"

    def fetch(self):
        import psycopg2.extras

        cursor = self.lpc_psycopg2_connection.cursor(cursor_factory=psycopg2.extras.DictCursor)

        cursor.execute("""
            SELECT
              pp."id",
              pp."path",
              pp."author",
              pp."status",
              pp."createdAt",
              pp."deletedAt",
              pd."screenshots"
            FROM pages_publishes AS pp
            LEFT JOIN pages_data AS pd
            USING ("version", "path")
        """)

        return cursor

    def get_count(self, iterable):
        cursor = self.lpc_psycopg2_connection.cursor()
        cursor.execute('SELECT COUNT(*) FROM pages_publishes')
        return next(cursor)[0]

    def transform(self, rows):
        return [{column.name(): column.transform(row, None) for column in self.schema} for row in rows]
