import time

from driver import Driver, SchemaColumn


class StockVideoDriver(Driver):
    schema = [
        SchemaColumn(schema={"name": "date", "type": "uint64"}, transformer=lambda b, c: int(time.mktime(b["date"].timetuple()))),
        SchemaColumn(schema={"name": "creative_id", "type": "uint64"}, transformer=lambda b, c: int(b["creative_id"])),
        SchemaColumn(schema={"name": "stock_creative_id", "type": "uint64"}, transformer=lambda b, c: int(b["stock_creative_id"])),
        SchemaColumn(schema={"name": "id", "type": "string"}, transformer=lambda b, c: str(b["_id"])),
        SchemaColumn(schema={"name": "video_id", "type": "string"}),
        SchemaColumn(schema={"name": "audio_id", "type": "string"}),
        SchemaColumn(schema={"name": "preset_id", "type": "string"}, transformer=lambda b, c: str(b["preset_id"])),
        SchemaColumn(schema={"name": "client_id", "type": "uint32"}, transformer=lambda b, c: int(b["client_id"])),
        SchemaColumn(schema={"name": "name", "type": "string"}),
        SchemaColumn(schema={"name": "data", "type": "any"}),
        SchemaColumn(schema={"name": "archive", "type": "boolean"}),
        SchemaColumn(schema={"name": "screenshot_url", "type": "string"}),
    ]
    yt_dump_dir = "//home/canvas/stock_video_additions"

    def fetch(self):
        return self.mongo.stock_video_additions.find()

    def transform(self, stock_additions):
        rows = []
        for stock_addition in stock_additions:
            row = {}
            for column in self.schema:
                row[column.name()] = column.transform(stock_addition, stock_addition)
            rows.append(row)
        return rows
