import time

from driver import Driver, SchemaColumn


class SubmissionsDriver(Driver):
    schema = [
        SchemaColumn(schema={"name": "date", "type": "uint64"}, transformer=lambda b, c: int(time.mktime(b["date"].timetuple()))),
        SchemaColumn(schema={"name": "id", "type": "string"}, transformer=lambda b, c: str(b["_id"])),
        SchemaColumn(schema={"name": "client_id", "type": "uint32"}, transformer=lambda b, c: int(b["client_id"]) if b.get("client_id") is not None else None),
        SchemaColumn(schema={"name": "landing_name", "type": "string"}),
        SchemaColumn(schema={"name": "landing_id", "type": "string"}),
        SchemaColumn(schema={"name": "form_id", "type": "string"}),
        SchemaColumn(schema={"name": "data", "type": "any"}),
    ]
    yt_dump_dir = "//home/canvas/submissions"

    def fetch(self):
        return self.mongo.blanding_submissions.find()

    def transform(self, batches):
        rows = []
        for batch in batches:
            row = {}
            for column in self.schema:
                row[column.name()] = column.transform(batch, batch)
            rows.append(row)
        return rows
