import time

from driver import Driver, SchemaColumn


class VideoAdditionsDriver(Driver):
    schema = [
        SchemaColumn(schema={"name": "date", "type": "uint64"}, transformer=lambda b, c: int(time.mktime(b["date"].timetuple()))),
        SchemaColumn(schema={"name": "creation_time", "type": "uint64"}, transformer=lambda b, c: int(time.mktime(b["creation_time"].timetuple())) if b.get("creation_time") else None),
        SchemaColumn(schema={"name": "creative_id", "type": "uint64"}, transformer=lambda b, c: int(b["creative_id"])),
        SchemaColumn(schema={"name": "stock_creative_id", "type": "uint64"}, transformer=lambda b, c: int(b["stock_creative_id"])),
        SchemaColumn(schema={"name": "id", "type": "string"}, transformer=lambda b, c: str(b["_id"])),
        SchemaColumn(schema={"name": "client_id", "type": "uint32"}, transformer=lambda b, c: int(b["client_id"])),
        SchemaColumn(schema={"name": "name", "type": "string"}),
        SchemaColumn(schema={"name": "data", "type": "any"}),
        SchemaColumn(schema={"name": "archive", "type": "boolean"}, transformer=lambda b, c: b["archive"]),
        SchemaColumn(schema={"name": "screenshot_url", "type": "string"}),
    ]
    yt_dump_dir = "//home/canvas/video_additions"

    def fetch(self):
        return self.mongo.video_additions.find({}, {
            "date": 1,
            "creation_time": 1,
            "creative_id": 1,
            "stock_creative_id": 1,
            "client_id": 1,
            "name": 1,
            "data": 1,
            "archive": 1,
            "screenshot_url": 1
        })

    def transform(self, video_additions):
        rows = []
        for video_addition in video_additions:
            row = {}
            for column in self.schema:
                row[column.name()] = column.transform(video_addition, video_addition)
            rows.append(row)
        return rows
