import time

from driver import Driver, SchemaColumn


class VideoConstructorFilesDriver(Driver):
    schema = [
        SchemaColumn(schema={"name": "id", "type": "string"}, transformer=lambda b, c: str(b["_id"])),
        SchemaColumn(schema={"name": "name", "type": "string"}),
        SchemaColumn(schema={"name": "client_id", "type": "uint32"}, transformer=lambda b, c: int(b["client_id"]) if b.get("client_id") is not None else None),
        SchemaColumn(schema={"name": "user_id", "type": "uint64"}, transformer=lambda b, c: int(b["user_id"])),
        SchemaColumn(schema={"name": "archive", "type": "boolean"}, transformer=lambda b, c: b["archive"]),
        SchemaColumn(schema={"name": "creation_time", "type": "uint64"}, transformer=lambda b, c: int(time.mktime(b["creation_time"].timetuple()))),
        SchemaColumn(schema={"name": "date", "type": "uint64"}, transformer=lambda b, c: int(time.mktime(b["date"].timetuple()))),
        SchemaColumn(schema={"name": "fps", "type": "uint32"}, transformer=lambda b, c: int(b["fps"]) if b.get("fps") is not None else None),
        SchemaColumn(schema={"name": "width", "type": "uint32"}, transformer=lambda b, c: int(b["width"])),
        SchemaColumn(schema={"name": "height", "type": "uint32"}, transformer=lambda b, c: int(b["height"])),
        SchemaColumn(schema={"name": "duration", "type": "double"}, transformer=lambda b, c: float(b["duration"])),
        SchemaColumn(schema={"name": "params", "type": "any"}),
        SchemaColumn(schema={"name": "scale", "type": "uint32"}, transformer=lambda b, c: int(b["scale"])),
        SchemaColumn(schema={"name": "status", "type": "string"}),
        SchemaColumn(schema={"name": "url", "type": "string"}),
        SchemaColumn(schema={"name": "audio_url", "type": "string"}, transformer=lambda b, c: str(b["audio_url"]) if b.get("audio_url") is not None else None),
        SchemaColumn(schema={"name": "mp4Url", "type": "string"}),
        SchemaColumn(schema={"name": "gifUrl", "type": "string"}),
        SchemaColumn(schema={"name": "packshotUrl", "type": "string"}, transformer=lambda b, c: str(b["packshotUrl"]) if b.get("packshotUrl") is not None else None),
        SchemaColumn(schema={"name": "previewUrl", "type": "string"}, transformer=lambda b, c: str(b["previewUrl"]) if b.get("previewUrl") is not None else None),
    ]
    yt_dump_dir = "//home/canvas/video_constructor_files"

    def fetch(self):
        return self.mongo.video_constructor_files.find()

    def transform(self, video_constructor_files):
        rows = []
        for video_constructor_files in video_constructor_files:
            row = {}
            for column in self.schema:
                row[column.name()] = column.transform(video_constructor_files, video_constructor_files)
            rows.append(row)
        return rows
