import time

from driver import Driver, SchemaColumn


class VideoFilesDriver(Driver):
    schema = [
        SchemaColumn(schema={"name": "date", "type": "uint64"}, transformer=lambda b, c: int(time.mktime(b["date"].timetuple()))),
        SchemaColumn(schema={"name": "creation_time", "type": "uint64"}, transformer=lambda b, c: int(time.mktime(b["creation_time"].timetuple())) if b.get("creation_time") else None),
        SchemaColumn(schema={"name": "stock_file_id", "type": "string"}),
        SchemaColumn(schema={"name": "id", "type": "string"}, transformer=lambda b, c: str(b["_id"])),
        SchemaColumn(schema={"name": "client_id", "type": "uint32"}, transformer=lambda b, c: int(b["client_id"])),
        SchemaColumn(schema={"name": "name", "type": "string"}),
        SchemaColumn(schema={"name": "type", "type": "string"}),
        SchemaColumn(schema={"name": "archive", "type": "boolean"}),
        SchemaColumn(schema={"name": "status", "type": "string"}),
        SchemaColumn(schema={"name": "strm_prefix", "type": "string"}),
        SchemaColumn(schema={"name": "url", "type": "string"}),
        SchemaColumn(schema={"name": "thumbnailUrl", "type": "string"}),
        SchemaColumn(schema={"name": "stillage_info", "type": "any"}),
        SchemaColumn(schema={"name": "sub_categories", "type": "any"}),
        SchemaColumn(schema={"name": "formats", "type": "any"}),
        SchemaColumn(schema={"name": "stillage_id", "type": "uint64"}),
    ]
    yt_dump_dir = "//home/canvas/video_files"

    def fetch(self):
        return self.mongo.video_files.find()

    def transform(self, video_files):
        rows = []
        for video_file in video_files:
            row = {}
            for column in self.schema:
                row[column.name()] = column.transform(video_file, video_file)
            rows.append(row)
        return rows
