# -*- coding: utf-8 -*-

import dumpers

import pymongo
import yt.wrapper as yt
import os

"""
Скрипт для запуска выгрузки бд канваса в YT локально.
Нужно только указать переменные окружения и поставить нужные модули из pip.
Помогает быстрее понять, почему упала выгрузка.
"""
if __name__ == "__main__":
    for var_name in ["YT_TOKEN", "MONGO_URI", "DUMPER", "YT_DUMP_DIR"]:
        if not os.environ.get(var_name):
            raise ValueError("Переменная окружения %s не задана" % var_name)

    # токен для YT
    YT_TOKEN = os.environ.get("YT_TOKEN")
    # ури для подключения к монге
    MONGO_URI = os.environ.get("MONGO_URI")
    # название дампера
    DUMPER = os.environ.get("DUMPER")
    # куда делаем дамп, например //tmp/palasonic/test_dump
    YT_DUMP_DIR = os.environ.get("YT_DUMP_DIR")

    yt_client = yt.YtClient(proxy="hahn", token=YT_TOKEN)
    yt_client.config['write_parallel']['enable'] = True
    yt_client.config['write_parallel']['unordered'] = True
    yt_client.config['write_parallel']['max_thread_count'] = 20
    # 1 Mb
    yt_client.config['write_retries']['chunk_size'] = 32 * 1024 * 1024
    # brotli allowes parallel writing in python2
    yt_client.config['proxy']['content_encoding'] = 'br'

    mongo = pymongo.MongoClient(host=MONGO_URI).canvas

    dumper_class = getattr(dumpers, DUMPER)

    dumper_class(
        yt_client=yt_client,
        mongo=mongo,
        lpc_psycopg2_connection=None,
        overwrite_existing=True,
        yt_dump_dir=YT_DUMP_DIR,
    ).run()
