import os

import sandbox.common.types.client as ctc
import sandbox.common.types.task as ctt

from sandbox import sdk2

from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.build.parameters import get_arcadia_params
from sandbox.projects.common.nanny import nanny


class CapacityInfraYpQuotaDistributorBuild(sdk2.Resource):
    """
    YP Quota Distributor Build Results
    """
    any_arch = True
    auto_backup = False
    executable = True
    releasable = True
    releasers = ['ndolganov', 'glebx777']
    ttl = 365
    arcadia_build_path = "infra/yp_quota_distributor/app/app"


class CapacityInfraYpQuotaDistributor(YaMakeTask, nanny.ReleaseToNannyTask):
    type = "CAPACITY_INFRA_YP_QUOTA_DISTRIBUTOR"
    client_tags = ctc.Tag.Group.LINUX
    input_parameters = get_arcadia_params()
    execution_space = 4 * 1024

    def get_resources(self):
        resources = {
            "description": 'YP Quota Distributor Build Results',
            "resource_path": os.path.basename(CapacityInfraYpQuotaDistributorBuild.arcadia_build_path),
            "resource_type": CapacityInfraYpQuotaDistributorBuild,
        }
        return {"project": resources}

    def get_targets(self):
        return [CapacityInfraYpQuotaDistributorBuild.arcadia_build_path]

    def get_arts(self):
        return [{"path": CapacityInfraYpQuotaDistributorBuild.arcadia_build_path}]

    def on_release(self, additional_parameters):
        additional_parameters["release_comments"] += "YP Quota Distributor Release\n"
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        self.mark_released_resources("stable", ttl="inf")
        YaMakeTask.on_release(self, additional_parameters)

    @property
    def release_template(self):
        return self.ReleaseTemplate(
            types=[ctt.ReleaseStatus.TESTING, ctt.ReleaseStatus.STABLE])


__Task__ = CapacityInfraYpQuotaDistributor
