# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import os
import logging
from sandbox import sdk2
from sandbox.projects.common import binary_task


class DefenceTableGeneration(binary_task.LastBinaryTaskRelease, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        binary_release = binary_task.binary_release_parameters(stable=True)
        enable_yav = True
        secrets = sdk2.parameters.YavSecret(
            "YAV secrets identifier",
            default="sec-01ft9zms1dyj1cty4ta6cvpkdh"
        )
        campaign_ids = sdk2.parameters.String("Campaign ID's", default="70")
        bucket_name = sdk2.parameters.String("S3 bucket name", default="cap-planning-temp")

    def on_execute(self):
        from infra.capacity_planning.abc_request_list.dispenser_requests.lib.excel_generation import create_files

        def get_s3_client(access_key_id, secret_access_key):
            import boto3
            session = boto3.session.Session(
                aws_access_key_id=access_key_id,
                aws_secret_access_key=secret_access_key
            )
            client = session.client(
                service_name='s3',
                endpoint_url='https://s3.mds.yandex.net',
                verify=False
            )
            return client

        def download_file_from_s3(client, bucket_name, path, local_path):
            client.download_file(Bucket=bucket_name, Key=path, Filename=local_path)

        def upload_file_to_s3(client, bucket_name, path, local_path):
            data = open(local_path, 'rb')
            client.put_object(Bucket=bucket_name, Key=path, Body=data)

        token = self.Parameters.secrets.data()['TOKEN']
        s3_key_id = self.Parameters.secrets.data()['S3_ACCESS_KEY_ID']
        s3_key_secret = self.Parameters.secrets.data()['S3_ACCESS_KEY_SECRET']
        campaign_ids = self.Parameters.campaign_ids.split(',')
        bucket = self.Parameters.bucket_name

        s3_client = get_s3_client(s3_key_id, s3_key_secret)

        logging.info('downloading files')

        download_file_from_s3(s3_client, bucket, 'defence_table/settings/base_costs.json', 'base_costs.json')
        download_file_from_s3(s3_client, bucket, 'defence_table/settings/hwr_orders.xlsx', 'hwr_orders.xlsx')

        logging.info('start creating')
        logging.info(os.listdir('.'))
        create_files(
            token=token,
            abc_token=token,
            campaign_ids=campaign_ids,
            api_timeout=300,
            base_costs_path='base_costs.json',
            hwr_orders_excel='hwr_orders.xlsx',
        )
        logging.info("end creating")
        logging.info(os.listdir('.'))

        daily_upload_prefix = 'defence_table/daily_builds/'
        last_upload_prefix = 'defence_table/last_build/'
        for file_name in os.listdir('.'):
            if not file_name.endswith('.xlsm'):
                continue
            daily_s3_path = daily_upload_prefix + file_name
            upload_file_to_s3(s3_client, bucket, daily_s3_path, file_name)
            last_s3_path = last_upload_prefix + file_name
            upload_file_to_s3(s3_client, bucket, last_s3_path, file_name)
