# coding: utf-8


from sandbox import sdk2


RELEASERS = [
    "robot-captcha",
    "bikulov",
    "ashagarov",
    "ulyanov",
    "iskostarev",
]


class PORTO_LAYER_CAPTCHA(sdk2.Resource):
    """
        Образ porto контейнера для проекта CAPTCHA
    """
    releasable = True
    releasers = RELEASERS


class PORTO_LAYER_CAPTCHA_IMAGE_GEN(sdk2.Resource):
    """
        Образ porto контейнера для генерилки картинок Капчи
    """
    releasable = True
    releasers = RELEASERS


class CAPTCHA_IMAGES_TESTING(sdk2.Resource):
    """
        Картинки для очереди testing Капчи
    """
    releasable = True
    releasers = RELEASERS


class CAPTCHA_IMAGES_EXP(sdk2.Resource):
    """
        Картинки для очереди exp Капчи
    """
    releasable = True
    releasers = RELEASERS


class CAPTCHA_IMAGES_OCR(sdk2.Resource):
    """
        Картинки для очереди ocr Капчи
    """
    releasable = True
    releasers = RELEASERS


class CAPTCHA_IMAGES_LOCALIZATION_KNOWN(sdk2.Resource):
    """
        Картинки для очереди localization_known Капчи
    """
    releasable = True
    releasers = RELEASERS


class CAPTCHA_IMAGES_LOCALIZATION_UNKNOWN(sdk2.Resource):
    """
        Картинки для очереди localization_unknown Капчи
    """
    releasable = True
    releasers = RELEASERS


class CAPTCHA_VOICE_INTRO(sdk2.Resource):
    """
        Трек с интро для звуковой капчи
    """
    releasable = True
    releasers = RELEASERS


class CAPTCHA_SERVER_EXECUTABLE(sdk2.Resource):
    """
        Исполняемый файл сервера Капчи
    """
    executable = True
    releasable = True
    releasers = RELEASERS


class CAPTCHA_KIKIMR_UPLOADER_EXECUTABLE(sdk2.Resource):
    """
        Исполняемый файл утилиты для загрузки данных Капчи в KiKiMR
    """
    executable = True
    releasable = True
    releasers = RELEASERS


class CAPTCHA_FALLBACK_ARCHIVE(sdk2.Resource):
    """
        Архив с картинками для использования в аварийной ситуации
    """
    releasable = True
    releasers = RELEASERS


class CAPTCHA_CLASSIFICATION_WORDLIST(sdk2.Resource):
    """
        Архив со словарём для построения фич
    """
    releasable = True
    releasers = RELEASERS


class CAPTCHA_NOISE_TOOL_EXECUTABLE(sdk2.Resource):
    """
        Исполняемый файл утилиты для зашумления картинок
    """
    executable = True
    releasable = True
    releasers = RELEASERS


class CAPTCHA_IMAGE_GENERATOR_RESOURCES(sdk2.Resource):
    """
        Архив с ресурсами для генератора картинок
    """
    releasable = True
    releasers = RELEASERS
