# -*- coding: utf-8 -*-

import os
from sandbox.sandboxsdk.parameters import ResourceSelector
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.common.build.YaMake import YaMakeTask


class CudaOmpiPackage(ResourceSelector):
    name = 'cuda_and_ompi_package'
    description = 'Archive with cuda and ompi headers and libs'
    required = True


class BuildCatBoost(YaMakeTask):
    type = 'BUILD_CATBOOST'
    input_parameters = YaMakeTask.input_parameters + [CudaOmpiPackage]

    def pre_build(self, source_dir):
        os.mkdir('mpi_folder')
        mpi_base_path = os.path.abspath('mpi_folder')
        run_process('tar -C mpi_folder -zxf {}'.format(self.sync_resource(self.ctx['cuda_and_ompi_package'])), log_prefix='extract_first')

        os.environ['LD_LIBRARY_PATH'] = os.path.join(mpi_base_path, 'lib') + ':' + os.environ.get('LD_LIBRARY_PATH', '')
        os.environ['LIBRARY_PATH'] = os.path.join(mpi_base_path, 'lib') + ':' + os.environ.get('LIBRARY_PATH', '')
        os.environ['CPLUS_INCLUDE_PATH'] = os.path.join(mpi_base_path, 'include') + ':' + os.environ.get('CPLUS_INCLUDE_PATH', '')


__Task__ = BuildCatBoost
