set -ex

for package in "software-properties-common" "build-essential" "wget" "subversion" "time"
do
    apt-get install -y ${package}
done

add-apt-repository -y -u ppa:deadsnakes/ppa

for python_version in "2.7" "3.5" "3.6" "3.7" "3.8"
do
    apt-get install -y python${python_version}
    apt-get install -y python${python_version}-dev

    if [ $python_version = "2.7" ]; then
        apt-get install -y python-virtualenv
    else
        apt-get install -y python${python_version}-venv
    fi;

    # https://askubuntu.com/questions/889535/how-to-install-pip-for-python-3-6-on-ubuntu-16-10
    curl https://bootstrap.pypa.io/get-pip.py | python${python_version}

    # catboost dependencies + psutil and scikit-learn for run_python_package_train
    for py_package in "graphviz" "matplotlib" "numpy>=1.16.0" "pandas>=0.24.0" "scipy" "plotly" "six" "psutil" "scikit-learn" "lightgbm" "xgboost"
    do
        python${python_version} -m pip install ${py_package}
    done
    
    if [ $python_version = "2.7" ]; then
        python${python_version} -m pip install enum34
    fi;     
    if [ $python_version = "3.5" ]; then
        python${python_version} -m pip install enum34
    fi;
done
