from sandbox import sdk2


class CatBoostBinary(sdk2.Resource):
    '''
    CatBoost binary from /arcadia/catboost/app/catboost
    '''
    executable = True
    releasable = True


class CatBoostRunPythonPackageTrain(sdk2.Resource):
    '''
    Utility for testing CatBoost python package training performance
        from catboost/yandex_specific/tools/performance_evaluation/run_python_package_train
    '''
    executable = True
    releasable = True


class CatBoostPerformanceEvaluationBinary(sdk2.Resource):
    '''
    CatBoost performance evaluation binary (arcadia-built)
        from catboost/yandex_specific/tools/performance_evaluation/bin
    '''
    executable = True
    releasable = True


class CatBoostPythonPackageWheel(sdk2.Resource):
    '''
    CatBoost python package wheel file
    '''
    python_version = sdk2.Attributes.String("Python version")
    svn_revision = sdk2.Attributes.Integer("Svn revision")
    with_cuda_support = sdk2.Attributes.Bool("With CUDA support")
    with_jupyter_widget_support = sdk2.Attributes.Bool("With Jupyter Widget support")


class CatBoostPerfTestJsonTask(sdk2.Resource):
    '''
    Json task for performance test with following attributes:
    "data" : "sbr:<sandbox_resource_number>"
    "cmd_params" : "<cmd_parameters_for_training_catboost>
    "name" : "<dataset_name>"
    '''
    pass


class CatBoostDataPrepParamsJson(sdk2.Resource):
    '''
    Json with data preparation params for run_python_package_train.
    See https://a.yandex-team.ru/arc/trunk/arcadia/catboost/yandex_specific/tools/performance_evaluation/run_python_package_train/README.md#--data-prep-params
      for details
    '''
    pass


class CatBoostPoolArchive(sdk2.Resource):
    '''
    Tar file with dataset
    '''
    pass
