
def get_ctx_for_make_catboost(revision_number=None, build_type=None):
    if revision_number is None:
        revision = ''
    else:
        revision = '@{}'.format(str(revision_number))
    if build_type is None:
        build_type = 'release'
    ctx = {
        'arts': 'catboost/app/catboost',
        'build_type': build_type,
        'checkout_arcadia_from_url': 'arcadia:/arc/trunk/arcadia{}'.format(revision),
        'checkout_mode': 'auto',
        'result_rt': 'CAT_BOOST_BINARY',
        'result_rd': 'catboost binary',
        'result_single_file': True,
        'targets': 'catboost/app',
        'definition_flags': '-DCUDA_VERSION=9.0'}
    return ctx


def get_ctx_for_make_catboost_run_python_package_train(revision_number=None, build_type=None):
    if revision_number is None:
        revision = ''
    else:
        revision = '@{}'.format(str(revision_number))
    if build_type is None:
        build_type = 'release'

    target = 'catboost/yandex_specific/tools/performance_evaluation/run_python_package_train'
    ctx = {
        'arts': target + '/run_python_package_train',
        'build_type': build_type,
        'checkout_arcadia_from_url': 'arcadia:/arc/trunk/arcadia{}'.format(revision),
        'checkout_mode': 'auto',
        'result_rt': 'CAT_BOOST_RUN_PYTHON_PACKAGE_TRAIN',
        'result_rd': 'catboost run_python_package_train',
        'result_single_file': True,
        'targets': target,
        'definition_flags': '-DCUDA_VERSION=9.0'}
    return ctx


def parse_used_ram_limit(used_ram_limit):
    """
        Params:
            used_ram_limit:
                can be string or number.
                if string format is the following:
                    '<size><measure of information>'
                    Supported measures of information (non case-sensitive):
                        MB
                        KB
                        GB

        returns ram limit in Mb.
    """

    if isinstance(used_ram_limit, bytes):
        used_ram_limit = used_ram_limit.decode('utf-8')

    if isinstance(used_ram_limit, unicode):
        if len(used_ram_limit) < 3:
            raise Exception(
                'Incorrect used_ram_limit string format: "%s", must be "<size><measure of information>"' % used_ram_limit
            )

        size_str = used_ram_limit[:-2]
        if not size_str.isdecimal():
            raise Exception(
                'Incorrect used_ram_limit string size format: "%s", must be numeric string' % size_str
            )

        size = int(size_str)
        measure_of_information = used_ram_limit[-2:].lower()
        if measure_of_information == 'kb':
            return int(size / 1000)
        if measure_of_information == 'mb':
            return size
        if measure_of_information == 'gb':
            return size * 1000
        else:
            raise Exception(
                'Incorrect used_ram_limit string measure_of_information format: "%s", must be "Kb", "Mb" or "Gb" ' % measure_of_information
            )
    else:
        return int(int(used_ram_limit) / 1000 / 1000)
