# coding: utf-8
import json
from enum import Enum


class CannonStatus(object):
    class Code(Enum):
        Broken = 0
        Ready = 1
        InAction = 2
        Done = 3

    def __init__(self, code, description=None):
        self.code = code  # type: CannonStatus.Code
        self.description = unicode(description)

    def to_json(self):
        return json.dumps({'code': self.code.name, 'description': self.description})

    @staticmethod
    def from_json(data):
        if isinstance(data, basestring):
            data = json.loads(data)
        return CannonStatus(CannonStatus.Code[data['code']], data.get('description'))
