from sandbox.common.types import resource as ctr
from sandbox.projects.common import binary_task


CHZ_TASKS_BUNDLE = 'CHZ_TASKS_BUNDLE'


class ChzBinaryTask(binary_task.LastBinaryTaskRelease):
    @property
    def binary_executor_query(self):
        return {
            "attrs": {
                "tasks_bundle": CHZ_TASKS_BUNDLE,
                "released": self.Parameters.binary_executor_release_type
            },
            "state": [ctr.State.READY]
        }


chz_binary_task_parameters = binary_task.binary_release_parameters(stable=True)
