# -*- coding: utf-8 -*-

from sandbox import sdk2


chz_releasers = [
    'CHZ'
]


class CHZ_BACKEND_BINARY(sdk2.Resource):
    """Chz backend binary resource"""

    releasable = True
    # auto_backup = True
    ttl = 14
    executable = True
    releasers = chz_releasers


class CHZ_DJ_BINARY(sdk2.Resource):
    """Chz backend binary resource"""

    releasable = True
    # auto_backup = True
    ttl = 14
    executable = True
    releasers = chz_releasers


class CHZ_DJ_SHARD(sdk2.Resource):
    """Chz recommender server shard binary resource"""

    releasable = True
    # auto_backup = True
    ttl = 30
    shard = True
    releasers = chz_releasers


class CHZ_DJ_RECOMMENDER_PACKAGE(sdk2.Resource):
    """Chz recommender server package resource (binary + configs)"""

    releasable = True
    ttl = 30
    releasers = chz_releasers


class CHZ_THEMATIC_CLASSIFIER(sdk2.Resource):
    """Chz classifier on thematic context zen articles """

    releasable = True
    auto_backup = True
    ttl = 365
    releasers = chz_releasers


class CHZ_TOURISM_CLASSIFIER(sdk2.Resource):
    """Chz classifier on tourism thematic context zen articles """

    releasable = True
    auto_backup = True
    ttl = 365
    releasers = chz_releasers


class CHZ_COLLECTION_CLASSIFIER(sdk2.Resource):
    """Chz classifier if article is about collection of orgs """

    releasable = True
    auto_backup = True
    ttl = 365
    releasers = chz_releasers


class CHZ_RANK_MODEL(sdk2.Resource):
    """RANK model to predict places in chz feed"""

    releasable = True
    auto_backup = True
    ttl = 365
    releasers = chz_releasers


class CHZ_MENU_ITEMS_RANK_MODEL(sdk2.Resource):
    """model for ranking maps menu items in chz backned"""

    releasable = True
    auto_backup = True
    ttl = 365
    releasers = chz_releasers


class CHZ_PLAN_FOR_DOLBILO(sdk2.Resource):
    """ Chz shooting plan for dolbilo """

    auto_backup = True
    ttl = 60
