import json
import logging

import sandbox.common.types.notification as ctn
import sandbox.common.types.task as ctt
from sandbox import sdk2


class GraphDiscoveryFakeTask(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        description = "This task emulates graph discovery"
        max_restarts = 1
        kill_timeout = 5 * 60  # Task timeout in seconds
        fail_on_any_error = True
        hidden = False
        dump_disk_usage = False  # Create disk_usage.yaml and peak_disk_usage.yaml

        notifications = [
            sdk2.Notification(
                statuses=[
                    ctt.Status.FAILURE,
                    ctt.Status.EXCEPTION,
                    ctt.Status.TIMEOUT,
                    ctt.Status.EXPIRED,
                ],
                recipients=["albazh@yandex-team.ru"],
                transport=ctn.Transport.EMAIL
            )
        ]

        arc_revision = sdk2.parameters.String("Arc revision", required=True)
        svn_revision = sdk2.parameters.Integer("Svn revision", required=True)
        platforms = sdk2.parameters.List("Target platforms", sdk2.parameters.String, required=True)

    def on_execute(self):
        logging.info("Started")
        resource = GraphDiscoveryFakeResultResource(
            self,
            "Graph discovery resource (arc revision {}, svn revision {})".format(
                self.Parameters.arc_revision,
                self.Parameters.svn_revision
            ),
            "affected_targets.json"
        )
        resource_data = sdk2.ResourceData(resource)

        logging.info("Graph evaluation")
        linux_platform_result = {
            "linux": [
                "ci/tms", "ci/storage"
            ]
        }

        logging.info("Converting result to json")
        result_json = json.dumps(linux_platform_result)

        logging.info("Storing result to disk")
        resource_data.path.write_bytes(result_json)

        resource_data.ready()
        logging.info("Finished")


class GraphDiscoveryFakeResultResource(sdk2.Resource):
    auto_backup = True
    ttl = 1
    sync_upload_to_mds = True
