# -*- coding: utf-8 -*-
import logging
from sandbox import sdk2
import sandbox.common.types.misc as ctm
import datetime
import random
import sandbox.common.types.task as ctt
from sandbox.common.types import resource as ctr
from sandbox.sandboxsdk import environments

from sandbox.projects.clickhouse.util.docker_image_helper import DockerImageHelper
from sandbox.projects.clickhouse.util.pr_info import PRInfo

from sandbox.projects.clickhouse.ClickhouseBuildLauncher import ClickhouseBuildLauncher
# from sandbox.projects.clickhouse.ClickhouseSpecialBuildLauncher import ClickhouseSpecialBuildLauncher
# from sandbox.projects.clickhouse.ClickhouseIntegrationTests import ClickhouseIntegrationTestsRelease
# from sandbox.projects.clickhouse.ClickhouseIntegrationTests import ClickhouseIntegrationTestsDebug
# from sandbox.projects.clickhouse.ClickhouseIntegrationTests import ClickhouseIntegrationTestsAsan
# from sandbox.projects.clickhouse.ClickhouseIntegrationTests import ClickhouseIntegrationTestsTsan
# from sandbox.projects.clickhouse.ClickhouseIntegrationTests import ClickhouseIntegrationTestsMsan
from sandbox.projects.clickhouse.ClickhouseRepoCloner import ClickhouseRepoCloner
# from sandbox.projects.clickhouse.ClickhouseStyle import ClickhouseStyle
# from sandbox.projects.clickhouse.ClickhouseStressTest import ClickhouseStressTestAsan
# from sandbox.projects.clickhouse.ClickhouseStressTest import ClickhouseStressTestTsan
# from sandbox.projects.clickhouse.ClickhouseStressTest import ClickhouseStressTestMsan
# from sandbox.projects.clickhouse.ClickhouseStressTest import ClickhouseStressTestUBsan
# from sandbox.projects.clickhouse.ClickhouseStressTest import ClickhouseStressTestDebug
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatelessTest import ClickhouseStatelessFunctionalTestRelease
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatelessTest import ClickhouseStatelessFunctionalTestReleaseDatabaseOrdinary
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatelessTest import ClickhouseStatelessFunctionalTestReleaseDatabaseReplicated
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatelessTest import ClickhouseStatelessFunctionalTestAsan
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatelessTest import ClickhouseStatelessFunctionalTestDebug
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatelessTest import ClickhouseStatelessFunctionalTestUBsan
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatelessTest import ClickhouseStatelessFunctionalTestTsan
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatelessTest import ClickhouseStatelessFunctionalTestPolymorphicParts
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatelessTest import ClickhouseStatelessFunctionalTestMsan
# from sandbox.projects.clickhouse.ClickhousePVSStudioCheck import ClickhousePVSStudioCheck
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatefulTest import ClickhouseFunctionalStatefulTestRelease
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatefulTest import ClickhouseFunctionalStatefulTestReleaseDatabaseOrdinary
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatefulTest import ClickhouseFunctionalStatefulTestReleaseDatabaseReplicated
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatefulTest import ClickhouseFunctionalStatefulTestAsan
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatefulTest import ClickhouseFunctionalStatefulTestUBSan
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatefulTest import ClickhouseFunctionalStatefulTestDebug
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatefulTest import ClickhouseFunctionalStatefulTestTsan
# from sandbox.projects.clickhouse.ClickhouseFunctionalStatefulTest import ClickhouseFunctionalStatefulTestMsan
# from sandbox.projects.clickhouse.ClickhouseFuzzer import ClickhouseFuzzerDebug
# from sandbox.projects.clickhouse.ClickhouseFuzzer import ClickhouseFuzzerASan
# from sandbox.projects.clickhouse.ClickhouseFuzzer import ClickhouseFuzzerMSan
# from sandbox.projects.clickhouse.ClickhouseFuzzer import ClickhouseFuzzerTSan
# from sandbox.projects.clickhouse.ClickhouseFuzzer import ClickhouseFuzzerUBSan
from sandbox.projects.clickhouse.ClickhousePerformanceComparison import ClickhousePerformanceComparison
# from sandbox.projects.clickhouse.ClickhouseGlibcCompatibilityCheck import ClickhouseGlibcCompatibilityCheck
# from sandbox.projects.clickhouse.ClickhouseUnitTest import ClickhouseUnitTest, ClickhouseUnitTestClang,\
#    ClickhouseUnitTestAsan, ClickhouseUnitTestMsan, ClickhouseUnitTestTsan, ClickhouseUnitTestUbsan
from sandbox.projects.clickhouse.ClickhouseDocsRelease import ClickhouseDocsRelease
from sandbox.projects.clickhouse.ClickhouseDockerHubPush import ClickhouseDockerHubPush
# from sandbox.projects.clickhouse.ClickhouseSplitBuildSmokeTest import ClickhouseSplitBuildSmokeTest
from sandbox.projects.clickhouse.ClickhouseTestflows import ClickhouseTestflows
# from sandbox.projects.clickhouse.ClickhouseFastTest import ClickhouseFastTest
# from sandbox.projects.clickhouse.ClickhouseSqlancerTest import ClickhouseSqlancerTest
from sandbox.projects.clickhouse.BaseOnCommitTask.base import PostStatuses
from sandbox.projects.clickhouse.util.github_helper import GithubHelper
from sandbox.projects.clickhouse.util.task_helper import get_nda_task_url, get_already_running_task
import sandbox.projects.common.binary_task as binary_task


# This list must be consistent with check_types list in testenv/jobs/clickhouse/binary_tasks.yaml
# excluding some special tasks
ON_COMMIT_TASKS = {
    ClickhouseBuildLauncher.get_context_name(): ClickhouseBuildLauncher,
    ClickhouseDockerHubPush.get_context_name(): ClickhouseDockerHubPush,
    # ClickhouseDocsRelease.get_context_name(): ClickhouseDocsRelease,
    # ClickhouseFastTest.get_context_name(): ClickhouseFastTest,
    # ClickhouseFunctionalStatefulTestAsan.get_context_name(): ClickhouseFunctionalStatefulTestAsan,
    # ClickhouseFunctionalStatefulTestDebug.get_context_name(): ClickhouseFunctionalStatefulTestDebug,
    # ClickhouseFunctionalStatefulTestMsan.get_context_name(): ClickhouseFunctionalStatefulTestMsan,
    # ClickhouseFunctionalStatefulTestRelease.get_context_name(): ClickhouseFunctionalStatefulTestRelease,
    # ClickhouseFunctionalStatefulTestReleaseDatabaseOrdinary.get_context_name(): ClickhouseFunctionalStatefulTestReleaseDatabaseOrdinary,
    # ClickhouseFunctionalStatefulTestReleaseDatabaseReplicated.get_context_name(): ClickhouseFunctionalStatefulTestReleaseDatabaseReplicated,
    # ClickhouseFunctionalStatefulTestTsan.get_context_name(): ClickhouseFunctionalStatefulTestTsan,
    # ClickhouseFunctionalStatefulTestUBSan.get_context_name(): ClickhouseFunctionalStatefulTestUBSan,
    # ClickhouseFuzzerASan.get_context_name(): ClickhouseFuzzerASan,
    # ClickhouseFuzzerDebug.get_context_name(): ClickhouseFuzzerDebug,
    # ClickhouseFuzzerMSan.get_context_name(): ClickhouseFuzzerMSan,
    # ClickhouseFuzzerTSan.get_context_name(): ClickhouseFuzzerTSan,
    # ClickhouseFuzzerUBSan.get_context_name(): ClickhouseFuzzerUBSan,
    # ClickhouseGlibcCompatibilityCheck.get_context_name(): ClickhouseGlibcCompatibilityCheck,
    # ClickhouseIntegrationTestsAsan.get_context_name(): ClickhouseIntegrationTestsAsan,
    # ClickhouseIntegrationTestsDebug.get_context_name(): ClickhouseIntegrationTestsDebug,
    # ClickhouseIntegrationTestsMsan.get_context_name(): ClickhouseIntegrationTestsMsan,
    # ClickhouseIntegrationTestsRelease.get_context_name(): ClickhouseIntegrationTestsRelease,
    # ClickhouseIntegrationTestsTsan.get_context_name(): ClickhouseIntegrationTestsTsan,
    ClickhousePerformanceComparison.get_context_name(): ClickhousePerformanceComparison,
    # ClickhousePVSStudioCheck.get_context_name(): ClickhousePVSStudioCheck,
    ClickhouseRepoCloner.get_context_name(): ClickhouseRepoCloner,
    # ClickhouseSpecialBuildLauncher.get_context_name(): ClickhouseSpecialBuildLauncher,
    # ClickhouseSplitBuildSmokeTest.get_context_name(): ClickhouseSplitBuildSmokeTest,
    # ClickhouseStatelessFunctionalTestAsan.get_context_name(): ClickhouseStatelessFunctionalTestAsan,
    # ClickhouseStatelessFunctionalTestDebug.get_context_name(): ClickhouseStatelessFunctionalTestDebug,
    # ClickhouseStatelessFunctionalTestMsan.get_context_name(): ClickhouseStatelessFunctionalTestMsan,
    # ClickhouseStatelessFunctionalTestPolymorphicParts.get_context_name(): ClickhouseStatelessFunctionalTestPolymorphicParts,
    # ClickhouseStatelessFunctionalTestRelease.get_context_name(): ClickhouseStatelessFunctionalTestRelease,
    # ClickhouseStatelessFunctionalTestReleaseDatabaseOrdinary.get_context_name(): ClickhouseStatelessFunctionalTestReleaseDatabaseOrdinary,
    # ClickhouseStatelessFunctionalTestReleaseDatabaseReplicated.get_context_name(): ClickhouseStatelessFunctionalTestReleaseDatabaseReplicated,
    # ClickhouseStatelessFunctionalTestTsan.get_context_name(): ClickhouseStatelessFunctionalTestTsan,
    # ClickhouseStatelessFunctionalTestUBsan.get_context_name(): ClickhouseStatelessFunctionalTestUBsan,
    # ClickhouseStressTestAsan.get_context_name(): ClickhouseStressTestAsan,
    # ClickhouseStressTestDebug.get_context_name(): ClickhouseStressTestDebug,
    # ClickhouseStressTestMsan.get_context_name(): ClickhouseStressTestMsan,
    # ClickhouseStressTestTsan.get_context_name(): ClickhouseStressTestTsan,
    # ClickhouseStressTestUBsan.get_context_name(): ClickhouseStressTestUBsan,
    # ClickhouseStyle.get_context_name(): ClickhouseStyle,
    ClickhouseTestflows.get_context_name(): ClickhouseTestflows,
    # ClickhouseUnitTest.get_context_name(): ClickhouseUnitTest,
    # ClickhouseUnitTestAsan.get_context_name(): ClickhouseUnitTestAsan,
    # ClickhouseUnitTestClang.get_context_name(): ClickhouseUnitTestClang,
    # ClickhouseUnitTestMsan.get_context_name(): ClickhouseUnitTestMsan,
    # ClickhouseUnitTestTsan.get_context_name(): ClickhouseUnitTestTsan,
    # ClickhouseUnitTestUbsan.get_context_name(): ClickhouseUnitTestUbsan,
    # ClickhouseSqlancerTest.get_context_name(): ClickhouseSqlancerTest,
}

MARKER_CHECK_TEXT = "Marker check"
MARKER_CHECK_URL = "https://clickhouse.tech/docs/en/development/continuous-integration/"


def get_new_clickhouse_images_names(image_names):
    return [x.replace('yandex/clickhouse-', 'clickhouse/') for x in image_names]


class ClickhouseCommitTrigger(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """
    Task polling github api and run subtasks with commit sha-1
    """

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group("GitHub parameters") as gh_block:
            github_token_key = sdk2.parameters.String("Token for github interactions", default="clickhouse-poll-robot-github-token2")
            github_repo = sdk2.parameters.String("GitHub repo name", default="ClickHouse/ClickHouse")

        with sdk2.parameters.Group("Check parameters") as check_block:
            check_commit_time_window = sdk2.parameters.Integer("Hours to check commits in past", default=20)

        with sdk2.parameters.Group("S3 parameters") as s3_block:
            s3_access_key_id = sdk2.parameters.String("S3 key id", default="clickhouse-robot-s3-key-id")
            s3_access_key = sdk2.parameters.String("S3 key", default="clickhouse-robot-s3-key")

        with sdk2.parameters.Group("Other parameters") as other_block:
            ext_params = binary_task.binary_release_parameters(stable=True)

        with sdk2.parameters.Output:
            commit_shas = sdk2.parameters.List(
                "Commit SHAs to check",
                value_type=sdk2.parameters.String,
                required=False,
                default=[],
            )

    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

        environments = (
            # Try to support non-binary release ('none' executor type), because
            # the binary one takes forever to publish, and @qoega takes forever
            # to fix it.
            # https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/clickhouse/ClickhousePullRequestTrigger/__init__.py?rev=r5801457
            # Match version to contrib: https://a.yandex-team.ru/arc/trunk/arcadia/contrib/python/PyGithub/github
            environments.PipEnvironment('pygithub', version='1.45'),
        )

    @property
    def binary_executor_query(self):
        return {
            "attrs": {"task_type": "CLICKHOUSE_SANDBOX_BINARY", "released": self.Parameters.binary_executor_release_type},
            "state": [ctr.State.READY]
        }

    def on_execute(self):
        venv = environments.VirtualEnvironment()

        with venv as venv:
            if self.Parameters.binary_executor_release_type == "none":
                environments.PipEnvironment('pygithub', venv=venv).prepare()
                environments.PipEnvironment('boto3', venv=venv).prepare()
                logging.debug("Set pip environment for nonbinary release")

            logging.getLogger().setLevel(logging.INFO)
            github_token = sdk2.Vault.data(self.Parameters.github_token_key)

            self.gh_helper = GithubHelper(github_token)
            self.docker_images_helper = DockerImageHelper(self.gh_helper)

            rate_is_ok, message = self.gh_helper.check_rate_limit()
            if not rate_is_ok:
                self.Parameters.description = "[can't run :(] " + message
                return

            repo = self.gh_helper.get_repo(self.Parameters.github_repo)

            date_from = datetime.datetime.now() - datetime.timedelta(hours=self.Parameters.check_commit_time_window)
            logging.info("Will search for commits since %s", date_from.strftime("%Y-%m-%d %H:%M:%S"))

            fake_pr = self.gh_helper.get_fake_pr()

            commits = self.gh_helper.get_all_commits_since(date_from, repo)
            pr_infos = [PRInfo(fake_pr, _commit) for _commit in commits]
            random.shuffle(pr_infos)

            for pr_info in pr_infos:
                waiting_task_names = []
                for check_context, TaskType in sorted(list(ON_COMMIT_TASKS.iteritems()), key=lambda x: x[1].order()):
                    now = datetime.datetime.utcnow()
                    logging.info("Processing '%s' for master @ %s", check_context, pr_info.sha)

                    if check_context in pr_info.statuses:
                        status = pr_info.statuses[check_context]
                        if status.state in ("failure", "success"):
                            logging.info("Check '{}' already completed for master @ {} with status '{}'".format(check_context, pr_info.sha, status.state))
                            continue
                        elif status.state == "pending":
                            if now - status.updated_at < datetime.timedelta(hours=3):
                                logging.info("Check '{}' is recently pending (since {}, now is {}), will not recheck for master @ {}'".format(
                                    check_context, status.updated_at, now, pr_info.sha))
                                continue
                            logging.info("Check '{}' is pending but too old (since {}, now is {}), will recheck for master @ {}'".format(
                                check_context, status.updated_at, now, pr_info.sha))
                        # exception status, meaning we have to rerun the check

                    need_to_run_desc = TaskType.need_to_run(pr_info)
                    if not need_to_run_desc.need_to_run:
                        logging.info("Not running task %s for commit %s because %s", check_context, pr_info.sha, need_to_run_desc.description)
                        if need_to_run_desc.post_statuses:
                            pr_info.pygithub_commit.create_status(state="success", context=check_context, description=need_to_run_desc.description[:140])
                        continue

                    waiting_task_names.append(check_context)

                    if not TaskType.get_resources(pr_info.pygithub_commit, repo, pr_info.pygithub_pr):
                        logging.info("Dependencies are not satisfied for task '%s' commit '%s' from master", check_context, pr_info.sha)
                        continue

                    if TaskType.get_images_names():
                        changed_images_for_pr, dockerhub_repo_name = self.docker_images_helper.get_changed_images_for_pr(repo, pr_info)

                        if changed_images_for_pr is None:
                            logging.info("Repo still not downloaded, cannot check docker image for task %s", TaskType.get_context_name())
                            continue

                        if dockerhub_repo_name == 'yandex':
                            logging.info("Still old dockerhub yandex/ repo")
                            images = TaskType.get_images_names()
                        else:
                            logging.info("New clickhouse/ repo")
                            images = get_new_clickhouse_images_names(TaskType.get_images_names())

                        docker_images_with_versions = self.docker_images_helper.get_changed_images_with_versions(
                            images, changed_images_for_pr, pr_info.pygithub_pr, pr_info.pygithub_commit, TaskType.get_context_name())

                        if docker_images_with_versions is None:
                            continue
                    else:
                        docker_images_with_versions = {}

                    logging.info("Docker images versions %s", docker_images_with_versions)

                    params = {
                        "commit_sha": pr_info.sha,
                        "pull_request_number": 0,
                    }
                    task = get_already_running_task(TaskType, params)
                    if task:
                        logging.info("The check '%s' for commit '%s' from master is already running (task id %s status %s)", check_context, pr_info.sha, task.id, task.status)
                        continue

                    # Check if there are any tasks already running for this check for this commit.
                    # We also have to check for SUCCESS task status, because the task might have
                    # finished after we checked the GitHub check status.
                    tasks = sdk2.Task.find(
                        TaskType,
                        input_parameters={"pull_request_number": pr_info.number, "commit_sha": pr_info.sha},
                        status=(ctt.Status.EXECUTING, ctt.Status.WAIT_TASK, ctt.Status.ENQUEUED, ctt.Status.ENQUEUING, ctt.Status.ASSIGNED, ctt.Status.FINISHING, ctt.Status.SUCCESS),
                        children=True,
                    ).limit(1)

                    logging.info("Found %ld tasks with same pull request and commit sha", tasks.count)

                    if tasks.count > 0:
                        task = tasks.first()
                        logging.info("Task '{}' id {} status {} updated at {} now {} already exists for master @ {}".format(
                            check_context, task.id, task.status, task.updated, now, pr_info.sha))
                        # Some broken tasks might show "success" status, but actually fail
                        # with an error. This shouldn't happen, but it happens and we need a
                        # way to restart them. If a task is "succeeded" for a long time already,
                        # but didn't post a status to github, and it had to post it, restart
                        # it. In other cases, wait for it.
                        assert need_to_run_desc.need_to_run
                        if (task.status != ctt.Status.SUCCESS
                                or not need_to_run_desc.post_statuses
                                or task.updated > now - datetime.timedelta(hours=1)):
                            logging.info("Will wait for the existing task")
                        continue

                    logging.info("Starting task of type %s for commit %s", check_context, pr_info.sha)

                    # We mostly care about the speed of PR workflow, and
                    # not about the speed of processing the master commits,
                    # so we can make all master tasks low priority.
                    priority = ctt.Priority(ctt.Priority.Class.SERVICE, ctt.Priority.Subclass.LOW)

                    task = TaskType(
                        self,
                        priority=priority,
                        description="Child of ClickhouseCommitTrigger task {}".format(self.id),
                        github_token_key="clickhouse-robot-github-token",
                        github_repo=self.Parameters.github_repo,
                        s3_access_key_id=self.Parameters.s3_access_key_id,
                        s3_access_key=self.Parameters.s3_access_key,
                        docker_images_with_versions=docker_images_with_versions,
                        **params
                    )
                    task.enqueue()
                    if task.post_statuses() == PostStatuses.ALWAYS:
                        logging.info("Creating pending status")
                        task.update_status(text="Started", url=get_nda_task_url(task.id), commit=pr_info.pygithub_commit)
                        logging.info("Pending status created")

            for pr_info in pr_infos:
                logging.info("Checking for finish master #%s @ %s", pr_info.sha)

                # Print which checks we expect to finish.
                github_checks = set(pr_info.statuses.keys())

                # Ignore some GitHub statuses we don't care about.
                github_checks_to_ignore = set([
                    MARKER_CHECK_TEXT,
                    # Might have a message about failing to clone submodules, this is OK
                    ClickhouseRepoCloner.get_context_name(),
                    ])

                # Yandex synchronization checks are started elsewhere, we don't care
                # about them.
                for x in github_checks:
                    if x.startswith('Yandex'):
                        github_checks_to_ignore.add(x)

                github_checks = github_checks.difference(github_checks_to_ignore)

                tasks = set(ON_COMMIT_TASKS.keys())
                # Remove some tasks we don't care about.
                tasks_to_ignore = set([
                    # It doesn't publish the status to GitHub.
                    ClickhouseRepoCloner.get_context_name(),
                    # This task is broken: it uses a repo resource parameter
                    # "docs_change" to determine whether it should run, and does
                    # this in get_resources() method. Should reimplement it to
                    # use the proper need_to_run() interface.
                    ClickhouseDocsRelease.get_context_name(),
                    ])
                # Remove the tasks we don't have to run
                for task_name, task_class in ON_COMMIT_TASKS.items():
                    result = task_class.need_to_run(pr_info)
                    logging.info(
                        "Task %s for commit %s: need to run %s, description '%s', post statuses %s",
                        task_name, pr_info.sha, result.need_to_run,
                        result.description, result.post_statuses)
                    if not result.need_to_run:
                        tasks_to_ignore.add(task_name)

                tasks = tasks.difference(tasks_to_ignore)

                waiting = tasks.difference(github_checks)
                unexpected = github_checks.difference(tasks)
                logging.info("{}: waiting for '{}', unexpected '{}', ignored GitHub checks '{}', ignored tasks '{}'".format(pr_info.sha, waiting, unexpected, github_checks_to_ignore, tasks_to_ignore))

                if len(waiting) == 0:
                    logging.info("'%s': Marker check is a success", pr_info.sha)
                    pr_info.pygithub_commit.create_status(state="success", context=MARKER_CHECK_TEXT, description="All checks started", target_url=MARKER_CHECK_URL)
                elif len(waiting) <= 3:
                    # Show what we're waiting for.
                    logging.info("'%s': Marker check is pending: ", pr_info.sha, ', '.join(waiting))
                    pr_info.pygithub_commit.create_status(state="pending", context=MARKER_CHECK_TEXT, description=("Waiting to start " + ', '.join(waiting))[:140], target_url=MARKER_CHECK_URL)
                else:
                    logging.info("'%s': Marker check is pending.", pr_info.sha)
                    pr_info.pygithub_commit.create_status(state="pending", context=MARKER_CHECK_TEXT, description="Starting checks...", target_url=MARKER_CHECK_URL)

            self.Parameters.commit_shas = [_commit.sha for _commit in commits]
