# -*- coding: utf-8 -*-
from sandbox.projects.clickhouse.BaseOnCommitTask.base_functional_test_task import ClickhouseFunctionalTestBase


class ClickhouseFunctionalStatefulTestBase(ClickhouseFunctionalTestBase):

    @staticmethod
    def require_internet():
        return True

    @staticmethod
    def get_images_names():
        return ["yandex/clickhouse-stateful-test"]


class ClickhouseFunctionalStatefulTestAsan(ClickhouseFunctionalStatefulTestBase):

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'deb', 'relwithdebuginfo', 'address', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Functional stateful tests (address)"


class ClickhouseFunctionalStatefulTestCoverage(ClickhouseFunctionalStatefulTestBase, object):
    class Parameters(ClickhouseFunctionalTestBase.Parameters):
        kill_timeout = 6 * 60 * 60  # 6 hours

    @staticmethod
    def get_images_names():
        return ["yandex/clickhouse-stateful-test-with-coverage"]

    @staticmethod
    def required_build_properties():
        return ('clang-11', 'deb', 'debug', 'none', 'bundled', 'unsplitted', 'enable', True)

    @staticmethod
    def get_context_name():
        return "Functional stateful tests (coverage)"

    def with_coverage(self):
        return True

    def get_additional_envs(self):
        envs = super(ClickhouseFunctionalStatefulTestCoverage, self).get_additional_envs()
        envs.update({"WITH_COVERAGE" : 1})
        return envs


class ClickhouseFunctionalStatefulTestDebug(ClickhouseFunctionalStatefulTestBase):

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'deb', 'debug', 'none', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Functional stateful tests (debug)"


class ClickhouseFunctionalStatefulTestMsan(ClickhouseFunctionalStatefulTestBase):

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'deb', 'relwithdebuginfo', 'memory', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Functional stateful tests (memory)"


class ClickhouseFunctionalStatefulTestRelease(ClickhouseFunctionalStatefulTestBase):

    @staticmethod
    def required_build_properties():
        return ('gcc-9', 'deb', 'relwithdebuginfo', 'none', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Functional stateful tests (release)"


class ClickhouseFunctionalStatefulTestReleaseDatabaseOrdinary(ClickhouseFunctionalStatefulTestBase, object):

    def get_additional_envs(self):
        envs = super(ClickhouseFunctionalStatefulTestReleaseDatabaseOrdinary, self).get_additional_envs()
        envs.update({"USE_DATABASE_ORDINARY": 1})
        return envs

    @staticmethod
    def required_build_properties():
        return ('gcc-9', 'deb', 'relwithdebuginfo', 'none', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Functional stateful tests (release, DatabaseOrdinary)"

    @staticmethod
    def need_to_run(pr_info):
        return ClickhouseFunctionalStatefulTestBase.run_if_master(pr_info)


class ClickhouseFunctionalStatefulTestReleaseDatabaseReplicated(ClickhouseFunctionalStatefulTestBase, object):

    def need_ramdrive_for_paths(self):
        return {"/var/lib/clickhouse/coordination", "/var/lib/clickhouse1/coordination", "/var/lib/clickhouse2/coordination"}

    def get_additional_envs(self):
        envs = super(ClickhouseFunctionalStatefulTestReleaseDatabaseReplicated, self).get_additional_envs()
        envs.update({"USE_DATABASE_REPLICATED": 1})
        return envs

    @staticmethod
    def required_build_properties():
        return ('gcc-9', 'deb', 'relwithdebuginfo', 'none', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Functional stateful tests (release, DatabaseReplicated)"

    @staticmethod
    def need_to_run(pr_info):
        return ClickhouseFunctionalStatefulTestBase.run_if_ordinary_pr(pr_info)


class ClickhouseFunctionalStatefulTestTsan(ClickhouseFunctionalStatefulTestBase):

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'deb', 'relwithdebuginfo', 'thread', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Functional stateful tests (thread)"


class ClickhouseFunctionalStatefulTestUBSan(ClickhouseFunctionalStatefulTestBase):

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'deb', 'relwithdebuginfo', 'undefined', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Functional stateful tests (ubsan)"
