# -*- coding: utf-8 -*-

from sandbox.projects.clickhouse.BaseOnCommitTask.base_functional_test_task import ClickhouseFunctionalTestBase


class ClickhouseStatelessFunctionalTestBase(ClickhouseFunctionalTestBase):
    @staticmethod
    def get_images_names():
        return ["yandex/clickhouse-stateless-test"]

    @staticmethod
    def required_build_properties():
        # This method is deprecated.
        return ('gcc-9', 'deb', 'relwithdebuginfo', 'none', 'bundled', 'unsplitted', 'disable', False)  # Release build


class ClickhouseStatelessFunctionalTestAsan(ClickhouseStatelessFunctionalTestBase):

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'deb', 'relwithdebuginfo', 'address', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Functional stateless tests (address)"


class ClickhouseStatelessFunctionalTestCoverage(ClickhouseStatelessFunctionalTestBase, object):
    class Parameters(ClickhouseFunctionalTestBase.Parameters):
        kill_timeout = 6 * 60 * 60  # 6 hours

    @staticmethod
    def get_images_names():
        return ["yandex/clickhouse-stateless-test-with-coverage"]

    @staticmethod
    def required_build_properties():
        return ('clang-11', 'deb', 'debug', 'none', 'bundled', 'unsplitted', 'enable', True)

    @staticmethod
    def get_context_name():
        return "Functional stateless tests (coverage)"

    def with_coverage(self):
        return True

    def get_additional_envs(self):
        envs = super(ClickhouseStatelessFunctionalTestCoverage, self).get_additional_envs()
        envs.update({"WITH_COVERAGE" : 1})
        return envs


class ClickhouseStatelessFunctionalTestDebug(ClickhouseStatelessFunctionalTestBase):

    class Parameters(ClickhouseFunctionalTestBase.Parameters):
        kill_timeout = 5 * 60 * 60  # 5 hours

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'deb', 'debug', 'none', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Functional stateless tests (debug)"


class ClickhouseStatelessFunctionalTestMsan(ClickhouseStatelessFunctionalTestBase):

    class Parameters(ClickhouseFunctionalTestBase.Parameters):
        kill_timeout = 4 * 60 * 60  # 4 hours

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'deb', 'relwithdebuginfo', 'memory', 'bundled', 'unsplitted', 'disable', False)

    def run_tests_randomly(self):
        return False

    @staticmethod
    def get_context_name():
        return "Functional stateless tests (memory)"


class ClickhouseStatelessFunctionalTestPolymorphicParts(ClickhouseStatelessFunctionalTestBase, object):

    def get_additional_envs(self):
        envs = super(ClickhouseStatelessFunctionalTestPolymorphicParts, self).get_additional_envs()
        envs.update({"USE_POLYMORPHIC_PARTS" : 1})
        return envs

    @staticmethod
    def get_context_name():
        return "Functional stateless tests (release, wide parts enabled)"


class ClickhouseStatelessFunctionalTestRelease(ClickhouseStatelessFunctionalTestBase):

    @staticmethod
    def get_context_name():
        return "Functional stateless tests (release)"


class ClickhouseStatelessFunctionalTestReleaseDatabaseOrdinary(ClickhouseStatelessFunctionalTestBase, object):

    def get_additional_envs(self):
        envs = super(ClickhouseStatelessFunctionalTestReleaseDatabaseOrdinary, self).get_additional_envs()
        envs.update({"USE_DATABASE_ORDINARY": 1})
        return envs

    @staticmethod
    def get_context_name():
        return "Functional stateless tests (release, DatabaseOrdinary)"

    @staticmethod
    def need_to_run(pr_info):
        return ClickhouseStatelessFunctionalTestBase.run_if_master(pr_info)


class ClickhouseStatelessFunctionalTestReleaseDatabaseReplicated(ClickhouseStatelessFunctionalTestBase, object):

    def need_ramdrive_for_paths(self):
        return {"/var/lib/clickhouse/coordination", "/var/lib/clickhouse1/coordination", "/var/lib/clickhouse2/coordination"}

    def get_additional_envs(self):
        envs = super(ClickhouseStatelessFunctionalTestReleaseDatabaseReplicated, self).get_additional_envs()
        envs.update({"USE_DATABASE_REPLICATED": 1})
        return envs

    @staticmethod
    def get_context_name():
        return "Functional stateless tests (release, DatabaseReplicated)"

    @staticmethod
    def need_to_run(pr_info):
        return ClickhouseStatelessFunctionalTestBase.run_if_ordinary_pr(pr_info)


class ClickhouseStatelessFunctionalTestTsan(ClickhouseStatelessFunctionalTestBase):

    class Parameters(ClickhouseFunctionalTestBase.Parameters):
        kill_timeout = 7 * 60 * 60

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'deb', 'relwithdebuginfo', 'thread', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Functional stateless tests (thread)"


class ClickhouseStatelessFunctionalTestUBsan(ClickhouseStatelessFunctionalTestBase):

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'deb', 'relwithdebuginfo', 'undefined', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Functional stateless tests (ubsan)"
