# -*- coding: utf-8 -*-

import os
from sandbox.projects.clickhouse.util.pr_info import PRInfo
from sandbox.projects.clickhouse.BaseOnCommitTask.base import NeedToRunDescription
from sandbox.projects.clickhouse.BaseOnCommitTask.base_functional_test_task import ClickhouseFunctionalTestBase
from sandbox.projects.clickhouse.BaseOnCommitTask.test_task import BaseOnCommitTestTask
import logging


def get_tests_to_run(pr_info):
    result = set([])

    if pr_info.changed_files is None:
        return []

    for fpath in pr_info.changed_files:
        if 'tests/queries/0_stateless/0' in fpath:
            logging.info('File %s changed and seems like stateless test', fpath)
            fname = fpath.split('/')[3]
            fname_without_ext = os.path.splitext(fname)[0]
            result.add(fname_without_ext + '.')
    return list(result)


class ClickhouseStatelessFunctionalTestFlakyCheck(ClickhouseFunctionalTestBase, object):

    def get_tests_to_run(self):
        return get_tests_to_run(PRInfo(self.pull_request, self.commit))

    def get_additional_envs(self):
        envs = super(ClickhouseStatelessFunctionalTestFlakyCheck, self).get_additional_envs()
        envs.update({"NUM_TRIES": "100", "MAX_RUN_TIME": "1800"})
        return envs

    @staticmethod
    def need_to_run(pr_info):
        if 'pr-backport' in pr_info.labels or 'release' in pr_info.labels:
            return NeedToRunDescription(False, 'Not ran for backport or release PRs', False)
        if not get_tests_to_run(pr_info):
            return NeedToRunDescription(False, 'Not found changed stateless tests', True)

        return BaseOnCommitTestTask.need_to_run(pr_info)

    @staticmethod
    def get_images_names():
        return ["yandex/clickhouse-stateless-test"]

    @staticmethod
    def required_build_properties():
        return ('clang-11', 'deb', 'relwithdebuginfo', 'address', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Functional stateless tests flaky check (address)"
