# -*- coding: utf-8 -*-
from sandbox.projects.clickhouse.BaseOnCommitTask.base_functional_test_task import ClickhouseFunctionalTestBase
from sandbox.projects.clickhouse.BaseOnCommitTask.base import NeedToRunDescription

import json
import logging


class ClickhouseStatelessFunctionalTestPytest(ClickhouseFunctionalTestBase):

    @staticmethod
    def get_images_names():
        return ["yandex/clickhouse-stateless-pytest"]

    @staticmethod
    def required_build_properties():
        return ('gcc-9', 'deb', 'relwithdebuginfo', 'none', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Functional stateless tests (pytest)"

    @staticmethod
    def need_to_run(pr_info):
        if 'pr-backport' in pr_info.labels or 'release' in pr_info.labels:
            return NeedToRunDescription(False, 'Not ran for backport or release PRs', False)
        return ClickhouseFunctionalTestBase.need_to_run(pr_info)

    def process(self, commit, repo, pull_request):
        logging.info("Run job function")

        self.run(self.commit, repo, pull_request)

        html_report_path = 'test_output/report.html'
        json_report_path = 'test_output/report.json'

        with open(json_report_path, 'r') as f:
            summary = json.load(f)['report']['summary']
        description = "fail: {}, passed: {}, skipped: {}".format(summary.get('failed', 0),
                                                                 summary.get('passed', 0),
                                                                 summary.get('skipped', 0))
        if summary.get('failed', 0) == 0:
            state = "success"
        else:
            # "failure" temporarily disabled due to not being ready
            state = "success"

        logging.info("Job finished with state %s and description %s", state, description)

        s3_path_prefix = str(pull_request.number) + "/" + self.commit.sha + "/" + self.get_context_name().lower().replace(' ', '_')
        logging.info("s3 upload prefix %s", s3_path_prefix)
        url = self.s3_client.upload_test_report_to_s3(html_report_path, s3_path_prefix + ".html")

        # TODO: upload test results to CI database

        return state, description, url
