# -*- coding: utf-8 -*-
from sandbox.projects.clickhouse.BaseOnCommitTask.base_fuzzer_task import ClickhouseFuzzer


class ClickhouseFuzzerDebug(ClickhouseFuzzer):

    @staticmethod
    def get_context_name():
        return 'AST fuzzer (debug)'

    @staticmethod
    def kind():
        return 'debug'

    @staticmethod
    def binary_to_download():
        return 'clang-11_debug_none_bundled_unsplitted_disable_False_binary'


class ClickhouseFuzzerASan(ClickhouseFuzzer):

    @staticmethod
    def get_context_name():
        return 'AST fuzzer (ASan)'

    @staticmethod
    def kind():
        return 'asan'

    @staticmethod
    def binary_to_download():
        return 'clang-11_relwithdebuginfo_address_bundled_unsplitted_disable_False_binary'


class ClickhouseFuzzerMSan(ClickhouseFuzzer):

    @staticmethod
    def get_context_name():
        return 'AST fuzzer (MSan)'

    @staticmethod
    def kind():
        return 'msan'

    @staticmethod
    def binary_to_download():
        return 'clang-11_relwithdebuginfo_memory_bundled_unsplitted_disable_False_binary'


class ClickhouseFuzzerTSan(ClickhouseFuzzer):

    @staticmethod
    def get_context_name():
        return 'AST fuzzer (TSan)'

    @staticmethod
    def kind():
        return 'tsan'

    @staticmethod
    def binary_to_download():
        return 'clang-11_relwithdebuginfo_thread_bundled_unsplitted_disable_False_binary'


class ClickhouseFuzzerUBSan(ClickhouseFuzzer):

    @staticmethod
    def get_context_name():
        return 'AST fuzzer (UBSan)'

    @staticmethod
    def kind():
        return 'ubsan'

    @staticmethod
    def binary_to_download():
        return 'clang-11_relwithdebuginfo_undefined_bundled_unsplitted_disable_False_binary'
