# -*- coding: utf-8 -*-
from sandbox.projects.clickhouse.BaseOnCommitTask.base_integration_tests_task import ClickhouseIntegrationTestsBase
from sandbox.projects.clickhouse.BaseOnCommitTask.test_task import BaseOnCommitTestTask
from sandbox.projects.clickhouse.BaseOnCommitTask.base import NeedToRunDescription
from sandbox.projects.clickhouse.util.pr_info import PRInfo
import logging


class ClickhouseIntegrationTestsFlakyCheck(ClickhouseIntegrationTestsBase):

    @staticmethod
    def required_build_properties():
        return ('clang-11', 'deb', 'relwithdebuginfo', 'address', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Integration tests flaky check (asan)"

    @staticmethod
    def get_tests_to_run(pr_info):
        result = set([])

        if pr_info.changed_files is None:
            return []

        for fpath in pr_info.changed_files:
            if 'tests/integration/test_' in fpath:
                logging.info('File %s changed and seems like integration test', fpath)
                result.add(fpath.split('/')[2])
        return list(result)

    @staticmethod
    def need_to_run(pr_info):
        if 'pr-backport' in pr_info.labels or 'release' in pr_info.labels:
            return NeedToRunDescription(False, 'Not ran for backport or release PRs', False)
        if not ClickhouseIntegrationTestsFlakyCheck.get_tests_to_run(pr_info):
            return NeedToRunDescription(False, 'Not found changed integration tests', True)

        return BaseOnCommitTestTask.need_to_run(pr_info)

    def get_json_params_dict(self, commit, pull_request):
        res = super(ClickhouseIntegrationTestsFlakyCheck, self).get_json_params_dict(commit, pull_request)
        res['pr_info'] = PRInfo(pull_request, commit).get_json_dict()
        return res
