# -*- coding: utf-8 -*-
from sandbox.projects.clickhouse.ClickhouseRepoCloner import ClickhouseRepoCloner
from sandbox.projects.clickhouse.resources import CLICKHOUSE_REPO
from sandbox import sdk2
import logging
import sandbox.common.types.resource as ctr


class ClickhousePullRequestPatcher(ClickhouseRepoCloner):

    def _update_version(self, version, pull_request):
        if "release" in set([l.name for l in pull_request.get_labels()]):
            logging.info("Release PR, don't get info about version from master builds")
            pr_number = pull_request.number
        else:
            pr_number = 0
        resources = sdk2.Resource.find(
            CLICKHOUSE_REPO,
            state=ctr.State.READY,
            attrs=dict(pr_number=pr_number)
        ).order(-CLICKHOUSE_REPO.id).limit(1)
        res = resources.first()
        if not res:
            logging.info("Will try to get revesion from repo")
        else:
            logging.info("Found resource with some version %s", res.id)
            if res.version != "":
                logging.info("Resource has version %s", res.version)
                splited = res.version.split(".")
                if len(splited) == 3:
                    version.tweak = 0
                else:
                    version.tweak = int(splited[3])

        return version.tweak_update()

    def get_version_type(self, pull_request):
        if "release" in set([l.name for l in pull_request.get_labels()]):
            return "stable"
        else:
            return "testing"

    @staticmethod
    def get_context_name():
        return "Apply PR patch"
