# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.clickhouse.BaseOnCommitTask.base import BaseOnCommitTask
from sandbox.projects.clickhouse.BaseOnCommitTask.base import NeedToRunDescription
from sandbox.projects.clickhouse.ClickhouseBuildLauncher import ClickhouseBuildLauncher

SPECIAL_BUILDS = [
    {
        "compiler": "clang-10",
        "build-type": "debug",
        "sanitizer": "",
        "package-type": "deb",
        "bundled": "bundled",
        "splitted": "unsplitted",
        "tidy": "enable",
        "with_coverage": True,
    },
]


class ClickhouseSpecialBuildLauncher(ClickhouseBuildLauncher):

    class Parameters(ClickhouseBuildLauncher.Parameters):
        build_setups = sdk2.parameters.JSON(
            'Build setups is JSON of dicts [{"compiler":"gcc-9", "build-type":"debug", "sanitizer": "none", "package-type": "binary", "bundled": "bundled"}, {...}]',
            default=SPECIAL_BUILDS,
            required=True
        )

    def additional_builds(self):
        return 0

    @staticmethod
    def get_context_name():
        return "ClickHouse special build check"

    def build_config_name(self):
        return "special_build_config"

    # Use the default (lowest) priority for special builds, because they are
    # less important and don't have any dependent tasks.
    @staticmethod
    def order():
        return BaseOnCommitTask.order()

    @staticmethod
    def need_to_run(pr_info):
        if 'pr-backport' in pr_info.labels or 'release' in pr_info.labels:
            return NeedToRunDescription(False, 'Not ran for backport or release PRs', False)

        return ClickhouseBuildLauncher.need_to_run(pr_info)
