# -*- coding: utf-8 -*-
import os
from sandbox.projects.clickhouse.BaseOnCommitTask.simple_test_task import SimpleDockerBuildTestTask
from sandbox.projects.clickhouse.BaseOnCommitTask.test_task import BaseOnCommitTestTask
from sandbox.projects.clickhouse.util.deprecated import SplitBuildSmokeTestDeprecated
from sandbox.projects.clickhouse.BaseOnCommitTask.base import NeedToRunDescription


class ClickhouseSplitBuildSmokeTest(SimpleDockerBuildTestTask):

    RESULT_LOG_NAME = "result.log"

    @staticmethod
    def get_context_name():
        return "Split build smoke test"

    @staticmethod
    def get_images_names():
        return ["yandex/clickhouse-split-build-smoke-test"]

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'binary', 'relwithdebuginfo', 'none', 'bundled', 'splitted', 'disable', False)

    @staticmethod
    def need_to_run(pr_info):
        if 'pr-backport' in pr_info.labels or 'release' in pr_info.labels:
            return NeedToRunDescription(False, 'Not ran for backport or release PRs', False)
        return BaseOnCommitTestTask.need_to_run(pr_info)

    def get_run_cmd(self, build_path, result_folder, server_log_folder, repo_path, perfraw_path):
        return "docker run --network=host --volume={}:/package_folder" \
               " --volume={}:/var/log/clickhouse-server" \
               " --volume={}:/test_output" \
               " {} >{}/{}".format(
                   build_path, server_log_folder, result_folder, self.get_single_image_with_version(), result_folder, self.RESULT_LOG_NAME)

    def _process_(self, log_path):
        name = os.path.basename(log_path)
        with open(log_path, 'r') as log:
            line = log.read().split('\n')[0].strip()
            if line != 'OK':
                return (name, "FAIL")
            else:
                return (name, "OK")

    def process_result(self, result_folder, server_log_folder, perfraw_path, commit, repo, pull_request):
        return SplitBuildSmokeTestDeprecated.process_result(self, result_folder, server_log_folder, perfraw_path, commit, repo, pull_request)
