# -*- coding: utf-8 -*-

from sandbox.projects.clickhouse.BaseOnCommitTask.simple_test_task import SimpleDockerBuildTestTask
from sandbox.projects.clickhouse.BaseOnCommitTask.base import NeedToRunDescription
from sandbox.projects.clickhouse.util.deprecated import SqlancerDeprecated


class ClickhouseSqlancerTest(SimpleDockerBuildTestTask):

    @staticmethod
    def get_images_names():
        return ["yandex/clickhouse-sqlancer-test"]

    def get_run_cmd(self, build_path, result_folder, server_log_folder, repo_path, perfraw_path):
        return [
            "docker run --cap-add=SYS_PTRACE --volume={}:/package_folder --volume={}:/test_output {}".format(build_path, result_folder, self.get_single_image_with_version())
        ]

    @staticmethod
    def order():
        return 1000

    def process_result(self, result_folder, server_log_folder, perfraw_path, commit, repo, pull_request):
        return SqlancerDeprecated.process_result(self, result_folder, server_log_folder, perfraw_path, commit, repo, pull_request)

    @staticmethod
    def need_to_run(pr_info):
        if 'pr-backport' in pr_info.labels or 'release' in pr_info.labels:
            return NeedToRunDescription(False, 'Not ran for backport or release PRs', False)

        return SimpleDockerBuildTestTask.need_to_run(pr_info)

    @staticmethod
    def get_context_name():
        return "SQLancer test"

    @staticmethod
    def required_build_properties():
        return ('clang-11', 'deb', 'debug', 'none', 'bundled', 'unsplitted', 'disable', False)
