# -*- coding: utf-8 -*-
from sandbox.projects.clickhouse.BaseOnCommitTask.base_stress_test_task import ClickhouseStressTestBase


class ClickhouseStressTestAsan(ClickhouseStressTestBase):

    class Requirements(ClickhouseStressTestBase.Requirements):
        ram = 96 * 1024

    @staticmethod
    def get_context_name():
        return "Stress test (address)"

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'deb', 'relwithdebuginfo', 'address', 'bundled', 'unsplitted', 'disable', False)


class ClickhouseStressTestDebug(ClickhouseStressTestBase):

    class Requirements(ClickhouseStressTestBase.Requirements):
        ram = 96 * 1024

    @staticmethod
    def get_context_name():
        return "Stress test (debug)"

    @staticmethod
    def required_build_properties():
        return ('clang-11', 'deb', 'debug', 'none', 'bundled', 'unsplitted', 'disable', False)


class ClickhouseStressTestMsan(ClickhouseStressTestBase):

    class Requirements(ClickhouseStressTestBase.Requirements):
        ram = 96 * 1024

    @staticmethod
    def get_context_name():
        return "Stress test (memory)"

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'deb', 'relwithdebuginfo', 'memory', 'bundled', 'unsplitted', 'disable', False)


class ClickhouseStressTestTsan(ClickhouseStressTestBase):

    class Requirements(ClickhouseStressTestBase.Requirements):
        ram = 96 * 1024

    @staticmethod
    def get_context_name():
        return "Stress test (thread)"

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'deb', 'relwithdebuginfo', 'thread', 'bundled', 'unsplitted', 'disable', False)


class ClickhouseStressTestUBsan(ClickhouseStressTestBase):

    class Requirements(ClickhouseStressTestBase.Requirements):
        ram = 96 * 1024

    @staticmethod
    def get_context_name():
        return "Stress test (undefined)"

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'deb', 'relwithdebuginfo', 'undefined', 'bundled', 'unsplitted', 'disable', False)
