# -*- coding: utf-8 -*-

from sandbox import sdk2
import logging
import os
import sandbox.common.types.resource as ctr
from sandbox.projects.clickhouse.BaseOnCommitTask.simple_test_task import SimpleDockerBuildTestTask
from sandbox.projects.clickhouse.BaseOnCommitTask.base import NeedToRunDescription
from sandbox.projects.clickhouse.resources import CLICKHOUSE_REPO
from sandbox.projects.clickhouse.util.task_helper import decompress_fast
from sandbox.projects.clickhouse.util.deprecated import StyleCheckDeprecated


class ClickhouseStyle(SimpleDockerBuildTestTask):

    @staticmethod
    def get_images_names():
        return ["yandex/clickhouse-style-test"]

    def get_run_cmd(self, build_path, result_folder, server_log_folder, repo_path, perfraw_path):
        return [
            "docker run --cap-add=SYS_PTRACE --volume={}:/ClickHouse --volume={}:/test_output {}".format(repo_path, result_folder, self.get_single_image_with_version())
        ]

    @staticmethod
    def order():
        return 1

    def process_result(self, result_folder, server_log_folder, perfraw_path, commit, repo, pull_request):
        return StyleCheckDeprecated.process_result(self, result_folder, server_log_folder, perfraw_path, commit, repo, pull_request)

    @staticmethod
    def need_to_run(pr_info):
        if 'pr-backport' in pr_info.labels or 'release' in pr_info.labels:
            return NeedToRunDescription(False, 'Not ran for backport or release PRs', False)

        return SimpleDockerBuildTestTask.need_to_run(pr_info)

    @staticmethod
    def get_context_name():
        return "Style Check"

    @classmethod
    def get_resources(cls, commit, repo, pull_request):
        logging.info("Searching for CLICKHOUSE_REPO at commit %s", commit.sha)
        bresources = sdk2.Resource.find(
            CLICKHOUSE_REPO,
            attrs=dict(
                commit=commit.sha,
                pr_number=pull_request.number,
            ),
            state=ctr.State.READY
        ).order(-CLICKHOUSE_REPO.id).limit(1)
        logging.info("Search finished")

        res = bresources.first()
        if not res:
            return None
        else:
            logging.info("Found resource %ld", res.id)
            return res

    def _save_resources(self, commit, repo, pull_request):
        logging.info("Downloading CLICKHOUSE_REPO resource")
        self.repo_resource = self.get_resources(commit, repo, pull_request)
        repo_data = sdk2.ResourceData(self.repo_resource)
        repo_path = str(repo_data.path)  # deb package
        logging.info("Download finished, repo path %s", repo_path)
        decompress_fast(repo_path)
        return os.path.join(str(self.path()), "ClickHouse")
