# -*- coding: utf-8 -*-
import logging
import os
import sandbox.sdk2.helpers
import shutil
import subprocess

from sandbox.projects.clickhouse.BaseOnCommitTask.simple_test_task import SimpleDockerBuildTestTask
from sandbox.projects.clickhouse.util.deprecated import TestflowsDeprecated
from sandbox.projects.clickhouse.BaseOnCommitTask.base import NeedToRunDescription


CLICKHOUSE_BINARY_PATH = "/usr/bin/clickhouse"
CLICKHOUSE_ODBC_BRIDGE_BINARY_PATH = "/usr/bin/clickhouse-odbc-bridge"


class ClickhouseTestflows(SimpleDockerBuildTestTask):

    @staticmethod
    def need_to_run(pr_info):
        if 'pr-backport' in pr_info.labels or 'release' in pr_info.labels:
            return NeedToRunDescription(False, 'Not ran for backport or release PRs', False)

        return SimpleDockerBuildTestTask.need_to_run(pr_info)

    @staticmethod
    def required_build_properties():
        return ('gcc-9', 'deb', 'relwithdebuginfo', 'none', 'bundled', 'unsplitted', 'disable', False)

    @staticmethod
    def get_context_name():
        return "Testflows check"

    @staticmethod
    def get_images_names():
        return ["yandex/clickhouse-testflows-runner"]

    def _install_clickhouse(self, debs_path):
        for package in ('clickhouse-common-static_', 'clickhouse-server_', 'clickhouse-client', 'clickhouse-common-static-dbg_'):  # order matters
            logging.info("Installing package %s", package)
            for f in os.listdir(debs_path):
                if package in f:
                    full_path = os.path.join(debs_path, f)
                    logging.info("Package found in %s", full_path)
                    log_name = "install_" + f + ".log"
                    with sandbox.sdk2.helpers.ProcessLog(self, logger=log_name) as pl:
                        cmd = "dpkg -i {}".format(full_path)
                        logging.info("Executing installation cmd %s", cmd)
                        retcode = subprocess.Popen(cmd, shell=True, stderr=pl.stdout, stdout=pl.stdout).wait()
                        if retcode == 0:
                            logging.info("Instsallation of %s successfull", full_path)
                        else:
                            raise Exception("Installation of %s failed", full_path)
                    break
            else:
                raise Exception("Package with {} not found".format(package))
        logging.info("All packages installed")
        os.chmod(CLICKHOUSE_BINARY_PATH, 0o777)
        os.chmod(CLICKHOUSE_ODBC_BRIDGE_BINARY_PATH, 0o777)
        result_path_bin = os.path.join(str(self.path()), "clickhouse")
        result_path_bridge = os.path.join(str(self.path()), "clickhouse-odbc-bridge")
        shutil.copy(CLICKHOUSE_BINARY_PATH, result_path_bin)
        shutil.copy(CLICKHOUSE_ODBC_BRIDGE_BINARY_PATH, result_path_bridge)
        return result_path_bin, result_path_bridge

    def get_run_cmd(self, build_path, result_folder, server_log, repo_path, perfraw_path):
        if not os.path.exists("{}/tests/testflows".format(repo_path)):
            return None

        image_cmd = ' --docker-image-version=' + self.get_single_image_version()
        binary_path, bridge_binary_path = self._install_clickhouse(build_path)

        return ("export CLICKHOUSE_TESTS_RESULT_PATH='{result_folder}' && cd {repo_path}/tests/testflows && ./runner {image_cmd} "
                "--binary={binary_path} --bridge-binary={bridge_binary_path} "
                "&& cp results.json {result_folder} && mv test.log {result_folder}").format(
                    repo_path=repo_path, image_cmd=image_cmd, binary_path=binary_path,
                    bridge_binary_path=bridge_binary_path, result_folder=result_folder)

    def process_result(self, result_folder, server_log_path, perfraw_path, commit, repo, pull_request):
        return TestflowsDeprecated.process_result(self, result_folder, server_log_path, perfraw_path, commit, repo, pull_request)
