# -*- coding: utf-8 -*-

import shutil
import os
from sandbox.projects.clickhouse.BaseOnCommitTask.simple_test_task import SimpleDockerBuildTestTask
from sandbox.projects.clickhouse.BaseOnCommitTask.base import NeedToRunDescription
from sandbox.projects.clickhouse.util.deprecated import UnitTestDeprecated


class ClickhouseUnitTestBase(SimpleDockerBuildTestTask):

    @staticmethod
    def get_images_names():
        return ["yandex/clickhouse-unit-test"]

    def get_run_cmd(self, build_path, result_folder, server_log_folder, repo_path, perfraw_path):
        pack_path = "{}/unit_tests_dbms".format(build_path)
        binary_path = os.path.join(str(self.path()), "./unit_tests_dbms")
        shutil.copy(pack_path, binary_path)
        os.chmod(binary_path, 0o777)
        return [
            "docker run --cap-add=SYS_PTRACE --volume={}:/unit_tests_dbms --volume={}:/test_output {}".format(binary_path, result_folder, self.get_single_image_with_version())
        ]

    @staticmethod
    def order():
        return 1000

    def process_result(self, result_folder, server_log_folder, perfraw_path, commit, repo, pull_request):
        return UnitTestDeprecated.process_result(self, result_folder, server_log_folder, perfraw_path, commit, repo, pull_request)

    @staticmethod
    def need_to_run(pr_info):
        if 'pr-backport' in pr_info.labels or 'release' in pr_info.labels:
            return NeedToRunDescription(False, 'Not ran for backport or release PRs', False)

        return SimpleDockerBuildTestTask.need_to_run(pr_info)


class ClickhouseUnitTest(ClickhouseUnitTestBase):
    @staticmethod
    def get_context_name():
        return "Unit tests release gcc"

    @staticmethod
    def required_build_properties():
        return ('gcc-9', 'binary', 'relwithdebuginfo', 'none', 'bundled', 'unsplitted', 'disable', False)


class ClickhouseUnitTestClang(ClickhouseUnitTestBase):
    @staticmethod
    def get_context_name():
        return "Unit tests release clang"

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'binary', 'relwithdebuginfo', 'none', 'bundled', 'unsplitted', 'disable', False)


class ClickhouseUnitTestAsan(ClickhouseUnitTestBase):
    @staticmethod
    def get_context_name():
        return "Unit tests ASAN"

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'binary', 'relwithdebuginfo', 'address', 'bundled', 'unsplitted', 'disable', False)


class ClickhouseUnitTestMsan(ClickhouseUnitTestBase):
    @staticmethod
    def get_context_name():
        return "Unit tests MSAN"

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'binary', 'relwithdebuginfo', 'memory', 'bundled', 'unsplitted', 'disable', False)


class ClickhouseUnitTestTsan(ClickhouseUnitTestBase):
    @staticmethod
    def get_context_name():
        return "Unit tests TSAN"

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'binary', 'relwithdebuginfo', 'thread', 'bundled', 'unsplitted', 'disable', False)


class ClickhouseUnitTestUbsan(ClickhouseUnitTestBase):
    @staticmethod
    def get_context_name():
        return "Unit tests UBSAN"

    @staticmethod
    def required_build_properties():
        return ('clang-10', 'binary', 'relwithdebuginfo', 'undefined', 'bundled', 'unsplitted', 'disable', False)
