# -*- coding: utf-8 -*-
import logging
import os
import sandbox.common.types.resource as ctr

from sandbox import sdk2
from sandbox.projects.clickhouse.BaseOnCommitTask.simple_test_task import SimpleDockerBuildTestTask
from sandbox.projects.clickhouse.resources import CLICKHOUSE_REPO
from sandbox.projects.clickhouse.util.task_helper import decompress_fast


class ClickhouseWoboqBuild(SimpleDockerBuildTestTask):

    class Parameters(SimpleDockerBuildTestTask.Parameters):
        kill_timeout = 9 * 60 * 60  # 9 hours

    @staticmethod
    def get_context_name():
        return "Woboq codebrowser"

    @classmethod
    def get_resources(cls, commit, repo, pull_request):
        logging.info("Searching for CLICKHOUSE_REPO at commit %s", commit.sha)
        bresources = sdk2.Resource.find(
            CLICKHOUSE_REPO,
            attrs=dict(
                commit=commit.sha,
                pr_number=pull_request.number,
            ),
            state=ctr.State.READY
        ).order(-CLICKHOUSE_REPO.id).limit(1)
        logging.info("Search finished")
        res = bresources.first()
        if not res:
            return None
        else:
            logging.info("Found resource %ld", res.id)
            return res

    @staticmethod
    def get_images_names():
        return ["yandex/clickhouse-codebrowser"]

    def _save_resources(self, commit, repo, pull_request):
        logging.info("Downloading CLICKHOUSE_REPO resource")
        self.repo_resource = self.get_resources(commit, repo, pull_request)
        repo_data = sdk2.ResourceData(self.repo_resource)
        repo_path = str(repo_data.path)  # deb package
        logging.info("Download finished, repo path %s", repo_path)
        decompress_fast(repo_path)
        return os.path.join(str(self.path()), "ClickHouse")

    def get_run_cmd(self, repo_path, result_folder, server_log_folder, _, perfraw_path):
        return "docker run --volume={}:/repo_folder --volume={}:/test_output " \
               "-e 'DATA=https://clickhouse-test-reports.s3.yandex.net/codebrowser/html_report/data' {}".format(repo_path, result_folder, self.get_single_image_with_version())

    def process_result(self, result_folder, server_log_path, perfraw_path, commit, repo, pull_request):
        s3_path_prefix = "codebrowser"
        logging.info("Result dir %s", result_folder)
        report_path = os.path.join(result_folder, "html_report")
        logging.info("Report path %s", report_path)
        # Too many messages
        logging.basicConfig(level=logging.CRITICAL)
        html_urls = self.s3_client.upload_test_folder_to_s3(report_path, s3_path_prefix)
        logging.basicConfig(level=logging.INFO)
        logging.info("HTML URLs {}".format(html_urls))
        index_html = '<a href="{}">HTML report</a>'.format("https://clickhouse-test-reports.s3.yandex.net/codebrowser/html_report/ClickHouse/index.html")

        test_results = [(index_html, "Look at the report")]

        return "success", "Report updated", test_results, []
