import sandbox.sdk2 as sdk2

LXC_CONTAINER = sdk2.service_resources.LxcContainer


class CLICKHOUSE_BUILD_LXC_CONTAINER(LXC_CONTAINER):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    releasers = ['alesap', 'milovidov', 'nik-kochetov', 'qoega']
    auto_backup = True
    ttl = 360


class CLICKHOUSE_INTEGRATION_TESTS_LXC_CONTAINER(LXC_CONTAINER):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    releasers = ['alesap', 'milovidov', 'nik-kochetov', 'qoega']
    auto_backup = True
    ttl = 360


class CLICKHOUSE_DOCS_LXC_CONTAINER(LXC_CONTAINER):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    releasers = ['alesap', 'milovidov', 'nik-kochetov', 'qoega']
    auto_backup = True
    ttl = 360


class CLICKHOUSE_REPO_NO_SUBMODULES(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    auto_backup = True
    sync_upload_to_mds = False
    commit = sdk2.Attributes.String("Commit sha", required=True)
    date = sdk2.Attributes.String("Date of clone", required=True)
    pr_number = sdk2.Attributes.Integer("Number of PR (0 means master)", default=0, required=True)
    version = sdk2.Attributes.String("Version of repo", required=True, default="")
    revision = sdk2.Attributes.String("Revision of repo", required=True, default="")
    docs_change = sdk2.Attributes.Bool("Contains documentation change", required=True, default=False)
    is_merge_commit = sdk2.Attributes.Bool("Is this build from merge commit", required=True, default=False)
    docs_release = sdk2.Attributes.Bool("It was released to stable in documentation", required=True, default=False)
    ttl = 2


class CLICKHOUSE_REPO(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    auto_backup = True
    sync_upload_to_mds = False
    commit = sdk2.Attributes.String("Commit sha", required=True)
    date = sdk2.Attributes.String("Date of clone", required=True)
    pr_number = sdk2.Attributes.Integer("Number of PR (0 means master)", default=0, required=True)
    revision = sdk2.Attributes.String("Revision of repo", required=True, default="")
    version = sdk2.Attributes.String("Version of repo", required=True, default="")
    docs_change = sdk2.Attributes.Bool("Contains documentation change", required=True, default=False)
    is_merge_commit = sdk2.Attributes.Bool("Is this build from merge commit", required=True, default=False)
    docs_release = sdk2.Attributes.Bool("It was released to stable in documentation", required=True, default=False)
    pvs_errors = sdk2.Attributes.Integer("Amount of PVS errors on this commit", required=True, default=0)
    pvs_errors_array = sdk2.Attributes.String("Files which contains pvs errors", required=True, default="[]")
    pvs_checked = sdk2.Attributes.Bool("Amount of PVS errors on this commit", required=True, default=False)
    ttl = 2


class CLICKHOUSE_BUILD(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    auto_backup = True
    sync_upload_to_mds = False
    commit = sdk2.Attributes.String("Commit sha", required=True)
    date = sdk2.Attributes.String("Date of clone", required=True)
    compiler = sdk2.Attributes.String("Compiler of build", required=True)
    build_type = sdk2.Attributes.String("Build type", required=True)
    sanitizer = sdk2.Attributes.String("Sanitizer", required=True, default="none")
    bundled = sdk2.Attributes.String("Bundled", required=True, default="bundled")
    splitted = sdk2.Attributes.String("Splitted", required=True, default="unsplitted")
    package_type = sdk2.Attributes.String("Package type", required=True)
    pr_number = sdk2.Attributes.Integer("Number of PR (0 means master)", default=0, required=True)
    revision = sdk2.Attributes.String("Revision of repo", required=True, default="")
    version = sdk2.Attributes.String("Version of repo", required=True, default="")
    tidy = sdk2.Attributes.String("Tidy", required=True, default=False)
    with_coverage = sdk2.Attributes.Bool("Build with coverage", required=True, default=False)
    elapsed_seconds = sdk2.Attributes.Integer("Seconds were spent to build this resource", required=True, default=0)
    ttl = 3


class CLICKHOUSE_BUILD_LOGS(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    auto_backup = True
    sync_upload_to_mds = False
    commit = sdk2.Attributes.String("Commit sha", required=True)
    date = sdk2.Attributes.String("Date of clone", required=True)
    compiler = sdk2.Attributes.String("Compiler of build", required=True)
    build_type = sdk2.Attributes.String("Build type", required=True)
    sanitizer = sdk2.Attributes.String("Sanitizer", required=True, default="none")
    package_type = sdk2.Attributes.String("Package type", required=True)
    splitted = sdk2.Attributes.String("Splitted", required=True, default="unsplitted")
    pr_number = sdk2.Attributes.Integer("Number of PR (0 means master)", default=0, required=True)
    tidy = sdk2.Attributes.String("Tidy", required=True, default=False)
    with_coverage = sdk2.Attributes.Bool("Build with coverage", required=True, default=False)
    ttl = 3


class CLICKHOUSE_PERFORMANCE_JSON(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    auto_backup = True
    sync_upload_to_mds = False
    commit = sdk2.Attributes.String("Commit sha", required=True)
    date = sdk2.Attributes.String("Date of clone", required=True)
    compiler = sdk2.Attributes.String("Compiler of build", required=True)
    is_slow_down = sdk2.Attributes.Bool("Does this run slowes down", default=False, required=True)
    ttl = 30


class CLICKHOUSE_BUILD_CACHE(sdk2.Resource):

    sync_upload_to_mds = False
    commit = sdk2.Attributes.String("Commit sha", required=True)
    date = sdk2.Attributes.String("Date of clone", required=True)
    compiler = sdk2.Attributes.String("Compiler of build", required=True)
    build_type = sdk2.Attributes.String("Build type", required=True)
    sanitizer = sdk2.Attributes.String("Sanitizer", required=True, default="none")
    package_type = sdk2.Attributes.String("Package type", required=True)
    splitted = sdk2.Attributes.String("Splitted", required=True, default="unsplitted")
    pr_number = sdk2.Attributes.Integer("Number of PR (0 means master)", default=0, required=True)
    # The base branch is helpful to distinguish the backport PRs. The ccache from
    # them is not very suitable for PRs to master, and vice versa.
    pr_base_branch = sdk2.Attributes.String("Base branch", required=True, default="master")
    bundled = sdk2.Attributes.String("Bundled", required=True, default="bundled")
    tidy = sdk2.Attributes.String("Tidy", required=True, default=False)
    with_coverage = sdk2.Attributes.Bool("Build with coverage", required=True, default=False)
    ttl = 5


class CLICKHOUSE_COVERAGE_PART(sdk2.Resource):
    sync_upload_to_mds = False
    commit = sdk2.Attributes.String("Commit sha", required=True)
    date = sdk2.Attributes.String("Date of clone", required=True)
    compiler = sdk2.Attributes.String("Compiler of build", required=True)
    build_type = sdk2.Attributes.String("Build type", required=True)
    sanitizer = sdk2.Attributes.String("Sanitizer", required=True, default="none")
    package_type = sdk2.Attributes.String("Package type", required=True)
    pr_number = sdk2.Attributes.Integer("Number of PR (0 means master)", default=0, required=True)
    bundled = sdk2.Attributes.String("Bundled", required=True, default="bundled")
    task_context_name = sdk2.Attributes.String("Task generated this part", required=True)
    splitted = sdk2.Attributes.String("Splitted", required=True, default="unsplitted")
    tidy = sdk2.Attributes.String("Tidy", required=True, default=False)
    ttl = 2
