# -*- coding: utf-8 -*-
from sandbox import sdk2
import shutil

import os
import sandbox.common.types.resource as ctr
from sandbox.projects.clickhouse.resources import CLICKHOUSE_BUILD, CLICKHOUSE_REPO_NO_SUBMODULES, CLICKHOUSE_REPO

from sandbox.projects.clickhouse.util.task_helper import decompress_fast


class ResourceHelper(object):
    """
    This class should be used for resource search, new resource types should be added here
    """
    def __init__(self, commit, repo, pull_request):
        self.commit = commit
        self.repo = repo
        self.pull_request = pull_request

    def get_build_resource(self, compiler, package_type, build_type, sanitizer, bundled, tidy):
        bresources = sdk2.Resource.find(
            CLICKHOUSE_BUILD,
            attrs=dict(
                commit=self.commit.sha,
                pr_number=self.pull_request.number,
                compiler=compiler,
                package_type=package_type,
                build_type=build_type,
                sanitizer=sanitizer,
                bundled=bundled,
                tidy=tidy
            ),
            state=ctr.State.READY
        ).order(-CLICKHOUSE_BUILD.id)

        return bresources.first()

    def get_repo_no_submodules_resource(self):
        rresources = sdk2.Resource.find(
            CLICKHOUSE_REPO_NO_SUBMODULES,
            attrs=dict(commit=self.commit.sha, pr_number=self.pull_request.number),
            state=ctr.State.READY
        ).order(-CLICKHOUSE_REPO_NO_SUBMODULES.id)

        return rresources.first()

    def get_repo_with_submodules_resource(self):
        rresources = sdk2.Resource.find(
            CLICKHOUSE_REPO,
            attrs=dict(commit=self.commit.sha, pr_number=self.pull_request.number),
            state=ctr.State.READY
        ).order(-CLICKHOUSE_REPO.id)

        return rresources.first()

    def save_build_resource(self, resource, path=None):
        build_data = sdk2.ResourceData(resource)
        build_path = str(build_data.path)
        if path:
            shutil.copytree(build_path, path)
            os.chmod(path, 0o0777)
            for f in os.listdir(path):
                os.chmod(os.path.join(path, f), 0o0777)
            return path
        return build_path

    def save_any_repo_resource(self, resource, path=None):
        repo_data = sdk2.ResourceData(resource)
        repo_path = str(repo_data.path)
        if not path:
            path = "."
        if not os.path.exists(path):
            os.mkdir(path)
        decompress_fast(repo_path, path)
        return os.path.join(path, "ClickHouse")
