# -*- coding: utf-8 -*-
import requests
import json
import time
import logging

SOLOMON_URL = 'http://api.solomon.search.yandex.net/push/json'
SOLOMON_PROJECT = 'clickhouse'
SOLOMON_CLUSTER = 'test_infrastructure'
SOLOMON_DEFAULT_SERVICE = 'github_quota'
SOLOMON_TYPE = 'output'


class SolomonHelper(object):
    def __init__(self, retries=5):
        self.retries = retries
        self.headers = {
            'Content-type': 'application/json',
        }

    # each row like {"labels": ("name", "value"), "ts":timestamp, "value": value}
    def push(self, rows, service=SOLOMON_DEFAULT_SERVICE):
        if not isinstance(rows, list):
            rows = [rows]

        data = {
            "commonLabels": {
                "project": SOLOMON_PROJECT,
                "cluster": SOLOMON_CLUSTER,
                "service": service,
            },
            "sensors": [{
                "labels": dict(row["labels"]),
                "ts": row["ts"],
                "value": row["value"],
            } for row in rows]
        }
        data_json = json.dumps(data)
        logging.info("Pushing to solomon %s", data_json)

        for i in range(self.retries):
            try:
                response = requests.post(
                    SOLOMON_URL,
                    data=data_json,
                    headers=self.headers
                )
                response.raise_for_status()
                break

            except Exception as e:
                logging.warning("Couldn't send %d rows to Solomon: %s", len(rows), e)
                time.sleep(1 * i)
        else:
            raise Exception("Coundn't push data to Solomon in %d tries", self.retries)
