# -*- coding: utf-8 -*-
import urllib
import urllib2
import os
from sandbox import sdk2
import sandbox.common.types.task as ctt
import logging
import subprocess
import requests
import time


DIFF_IN_CODE_EXT = [".xml", ".cpp", ".h", ".c", ".cc", ".hpp", ".H", ".C", ".sql", ".reference", ".py", ".sh", ".cmake", ".python"]
DIFF_IN_DOCUMENTATION_EXT = [".html", ".md", ".yml", ".txt", ".css", ".js", ".xml", ".ico", ".conf", ".svg", ".png", ".jpg", ".py", ".sh"]
SPECIAL_FILENAME_PARTS = ["contrib", "CMakeLists.txt", "ya.make", "Dockerfile", "packager", "debian/", "clickhouse-test", "tests/"]
SUBMODULE_FILES = [".gitmodules", "contrib/"]


def _special_file_in_filename(special_files, f):
    for special_file in special_files:
        if special_file in f:
            return True
    return False


def get_task_url(task_id):
    return "https://sandbox.yandex-team.ru/task/{}/view".format(task_id)


def get_nda_task_url(task_id):
    task_url = get_task_url(task_id)
    encoded_url = urllib.quote_plus(task_url)
    fetcher = urllib2.urlopen('https://nda.ya.ru/--?url=' + encoded_url)
    return fetcher.read()


def has_changes_in_code(pr_info):
    # If the list wasn't built yet by repo cloner task, the best we can do is to
    # assume that there were changes.
    if pr_info.changed_files is None:
        return True

    for f in pr_info.changed_files:
        _, ext = os.path.splitext(f)
        if ext in DIFF_IN_CODE_EXT or _special_file_in_filename(SPECIAL_FILENAME_PARTS, f):
            return True
    return False


def has_changes_in_documentation(pr_info):
    # If the list wasn't built yet by repo cloner task, the best we can do is to
    # assume that there were changes.
    if pr_info.changed_files is None:
        return True

    for f in pr_info.changed_files:
        _, ext = os.path.splitext(f)
        if ext in DIFF_IN_DOCUMENTATION_EXT or 'Dockerfile' in f:
            return True
    return False


def has_changes_in_submodules(gh_helper, commit, pull_request):
    if pull_request.number == 0:
        changed_files = gh_helper.get_commit_changed_files(commit)
    else:
        changed_files = gh_helper.get_pr_changed_files(pull_request)

    for file_prefix in SUBMODULE_FILES:
        for changed_file in changed_files:
            if changed_file.startswith(file_prefix):
                return True
    return False


def get_already_running_task(task_type, input_params):
    tasks = sdk2.Task.find(
        task_type,
        input_parameters=input_params,
        status=(ctt.Status.Group.EXECUTE, ctt.Status.SUCCESS, ctt.Status.ENQUEUED, ctt.Status.ENQUEUING, ctt.Status.ASSIGNED),
        children=True
    ).limit(1)

    logging.info("Found %s tasks of type %s", tasks.count, task_type)

    return tasks.first()


def compress_file_fast(path, archive_path):
    if os.path.exists('/usr/bin/pigz'):
        subprocess.check_call("pigz < {} > {}".format(path, archive_path), shell=True)
    else:
        subprocess.check_call("gzip < {} > {}".format(path, archive_path), shell=True)


def compress_fast(path, archive_path, exclude=None):
    pigz_part = ''
    if os.path.exists('/usr/bin/pigz'):
        logging.info("pigz found, will compress and decompress faster")
        pigz_part = "--use-compress-program='pigz'"
    else:
        pigz_part = '-z'
        logging.info("no pigz, compressing with default tar")

    if exclude is None:
        exclude_part = ""
    elif isinstance(exclude, list):
        exclude_part = " ".join(["--exclude {}".format(x) for x in exclude])
    else:
        exclude_part = "--exclude {}".format(str(exclude))

    fname = os.path.basename(path)
    if os.path.isfile(path):
        path = os.path.dirname(path)
    else:
        path += "/.."
    cmd = "tar {} {} -cf {} -C {} {}".format(pigz_part, exclude_part, archive_path, path, fname)
    logging.debug("compress_fast cmd:{}".format(cmd))
    subprocess.check_call(cmd, shell=True)


def decompress_fast(archive_path, result_path=None):
    pigz_part = ''
    if os.path.exists('/usr/bin/pigz'):
        logging.info("pigz found, will compress and decompress faster ('{}' -> '{}')".format(archive_path, result_path))
        pigz_part = "--use-compress-program='pigz'"
    else:
        pigz_part = '-z'
        logging.info("no pigz, decompressing with default tar ('{}' -> '{}')".format(archive_path, result_path))

    if result_path is None:
        subprocess.check_call("tar {} -xf {}".format(pigz_part, archive_path), shell=True)
    else:
        subprocess.check_call("tar {} -xf {} -C {}".format(pigz_part, archive_path, result_path), shell=True)


def get_ci_config(pull_request, commit):
    s3_setup_path = 'https://clickhouse-test-reports.s3.yandex.net/{}/{}/repo/ci_config.json'.format(pull_request.number, commit.sha)
    for i in range(5):
        try:
            response = requests.get(s3_setup_path)
            if response.ok:
                return response.json()
        except Exception as ex:
            logging.info("Exception fetching config from s3 %s", str(ex))
        time.sleep(0.1)
    else:
        logging.info("CI config not found :( for PR %s commit %s, will use default from params", pull_request.number, commit.sha)
        return {}
