PY23_LIBRARY()

OWNER(
    alesap
)

PY_SRCS(
    __init__.py
)

PEERDIR(
    sandbox/sdk2
)

SET(PROJECT_DIR "sandbox/projects/clickhouse")

# List of tasks must be consistent with check_types list in testenv/jobs/clickhouse/binary_tasks.yaml
# But if you are adding a new task, first you must commit it, and then update testenv with a separate
# commit.
PEERDIR(
    ${PROJECT_DIR}/BaseOnCommitTask
    ${PROJECT_DIR}/ClickhouseBuilder
    ${PROJECT_DIR}/ClickhouseBuildLauncher
    ${PROJECT_DIR}/ClickhouseCommitTrigger
    ${PROJECT_DIR}/ClickhouseCoverage
    ${PROJECT_DIR}/ClickhouseSanitizerCoverage
    ${PROJECT_DIR}/ClickhouseDeployBinaryTask
    ${PROJECT_DIR}/ClickhouseDockerHubPush
    ${PROJECT_DIR}/ClickhouseDocsCheck
    ${PROJECT_DIR}/ClickhouseDocsRelease
    ${PROJECT_DIR}/ClickhouseFastTest
    ${PROJECT_DIR}/ClickhouseFastTest
    ${PROJECT_DIR}/ClickhouseFunctionalStatefulTest
    ${PROJECT_DIR}/ClickhouseFunctionalStatelessTest
    ${PROJECT_DIR}/ClickhouseFunctionalStatelessTestFlakyCheck
    ${PROJECT_DIR}/ClickhouseFunctionalStatelessTestPytest
    ${PROJECT_DIR}/ClickhouseFuzzer
    ${PROJECT_DIR}/ClickhouseGlibcCompatibilityCheck
    ${PROJECT_DIR}/ClickhouseIntegrationTests
    ${PROJECT_DIR}/ClickhouseIntegrationTestsFlakyCheck
    ${PROJECT_DIR}/ClickhouseKeeperJepsen
    ${PROJECT_DIR}/ClickhousePerformanceComparison
    ${PROJECT_DIR}/ClickhousePullRequestPatcher
    ${PROJECT_DIR}/ClickhousePullRequestTrigger
    ${PROJECT_DIR}/ClickhousePVSStudioCheck
    ${PROJECT_DIR}/ClickhouseRelease
    ${PROJECT_DIR}/ClickhouseRepoCloner
    ${PROJECT_DIR}/ClickhouseSpecialBuildLauncher
    ${PROJECT_DIR}/ClickhouseSplitBuildSmokeTest
    ${PROJECT_DIR}/ClickhouseSqlancerTest
    ${PROJECT_DIR}/ClickhouseStressTest
    ${PROJECT_DIR}/ClickhouseStyle
    ${PROJECT_DIR}/ClickhouseTestflows
    ${PROJECT_DIR}/ClickhouseTestflows
    ${PROJECT_DIR}/ClickhouseTimerTrigger
    ${PROJECT_DIR}/ClickhouseUnitTest
    ${PROJECT_DIR}/ClickhouseWoboqBrowser
    ${PROJECT_DIR}/resources
    ${PROJECT_DIR}/util
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    BaseOnCommitTask
    ClickhouseBuilder
    ClickhouseBuildLauncher
    ClickhouseCommitTrigger
    ClickhouseCoverage
    ClickhouseSanitizerCoverage
    ClickhouseDeployBinaryTask
    ClickhouseDockerHubPush
    ClickhouseDocsCheck
    ClickhouseDocsRelease
    ClickhouseFunctionalStatefulTest
    ClickhouseFunctionalStatelessTest
    ClickhouseFunctionalStatelessTestFlakyCheck
    ClickhouseFunctionalStatelessTestPytest
    ClickhouseFuzzer
    ClickhouseGlibcCompatibilityCheck
    ClickhouseIntegrationTests
    ClickhouseIntegrationTestsFlakyCheck
    ClickhouseKeeperJepsen
    ClickhousePerformanceComparison
    ClickhousePullRequestPatcher
    ClickhousePullRequestTrigger
    ClickhousePVSStudioCheck
    ClickhouseRelease
    ClickhouseRepoCloner
    ClickhouseSplitBuildSmokeTest
    ClickhouseSqlancerTest
    ClickhouseStressTest
    ClickhouseStyle
    ClickhouseTestflows
    ClickhouseTimerTrigger
    ClickhouseUnitTest
    ClickhouseWoboqBrowser
    util
)
